/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat;
import org.jclouds.predicates.Validator;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeatTest")
public class FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeatTest {
    Validator<String> okValidator = new Validator<String>(){

        public void validate(String t) throws IllegalArgumentException {
        }
    };

    public void testSharedName() {
        FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat fn = new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat("jclouds", '_', Suppliers.ofInstance((Object)"123"), this.okValidator);
        Assert.assertEquals((String)fn.sharedNameForGroup("cluster"), (String)"jclouds_cluster");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("jclouds_cluster"), (String)"cluster");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("jclouds_cluster"), null);
        Assert.assertTrue((boolean)fn.containsGroup("cluster").apply((Object)"jclouds_cluster"));
    }

    public void testOkToHaveDelimiterInGroupOnUniqueName() {
        FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat fn = new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat("jclouds", '_', Suppliers.ofInstance((Object)"123"), this.okValidator);
        Assert.assertEquals((String)fn.sharedNameForGroup("cluster_"), (String)"jclouds_cluster_");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("jclouds_cluster_"), (String)"cluster_");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("jclouds_cluster_"), null);
        Assert.assertTrue((boolean)fn.containsGroup("cluster_").apply((Object)"jclouds_cluster_"));
    }

    public void testSharedNameWithHyphenInGroup() {
        FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat fn = new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat("jclouds", '_', Suppliers.ofInstance((Object)"123"), this.okValidator);
        Assert.assertEquals((String)fn.sharedNameForGroup("cluster-"), (String)"jclouds_cluster-");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("jclouds_cluster-"), (String)"cluster-");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("jclouds_cluster-"), null);
        Assert.assertTrue((boolean)fn.containsGroup("cluster-").apply((Object)"jclouds_cluster-"));
    }

    public void testNextName() {
        FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat fn = new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat("jclouds", '_', Suppliers.ofInstance((Object)"123"), this.okValidator);
        Assert.assertEquals((String)fn.uniqueNameForGroup("cluster"), (String)"jclouds_cluster_123");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("jclouds_cluster_123"), (String)"cluster_123");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("jclouds_cluster_123"), (String)"cluster");
        Assert.assertTrue((boolean)fn.containsGroup("cluster").apply((Object)"jclouds_cluster_123"));
    }

    public void testCannotFindSharedNameWhenDelimiterWrong() {
        FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat fn = new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat("jclouds", '_', Suppliers.ofInstance((Object)"123"), this.okValidator);
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("jclouds#cluster"), null);
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("jclouds#cluster"), null);
        Assert.assertFalse((boolean)fn.containsGroup("cluster").apply((Object)"jclouds#cluster"));
    }

    public void testCannotFindNextNameWhenDelimiterWrong() {
        FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat fn = new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat("jclouds", '_', Suppliers.ofInstance((Object)"123"), this.okValidator);
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("jclouds#cluster#123"), null);
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("jclouds#cluster#123"), null);
        Assert.assertFalse((boolean)fn.containsGroup("cluster").apply((Object)"jclouds#cluster#123"));
    }

    public void testPropertyChangesDelimiter() {
        GroupNamingConvention fn = ((GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.compute.resourcename-delimiter")).to('#');
            }
        }}).getInstance(GroupNamingConvention.Factory.class)).create();
        Assert.assertEquals((String)fn.sharedNameForGroup("cluster"), (String)"jclouds#cluster");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("jclouds#cluster"), (String)"cluster");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("jclouds#cluster"), null);
        Assert.assertTrue((boolean)fn.containsGroup("cluster").apply((Object)"jclouds#cluster"));
    }

    public void testPropertyChangesPrefix() {
        GroupNamingConvention fn = ((GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.compute.resourcename-prefix")).to("kclouds");
            }
        }}).getInstance(GroupNamingConvention.Factory.class)).create();
        Assert.assertEquals((String)fn.sharedNameForGroup("cluster"), (String)"kclouds-cluster");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("kclouds-cluster"), (String)"cluster");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("kclouds-cluster"), null);
        Assert.assertTrue((boolean)fn.containsGroup("cluster").apply((Object)"kclouds-cluster"));
    }

    public void testCanChangeSuffixSupplier() {
        GroupNamingConvention fn = ((GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)Suppliers.ofInstance((Object)"foo"));
            }
        }}).getInstance(GroupNamingConvention.Factory.class)).create();
        Assert.assertEquals((String)fn.uniqueNameForGroup("cluster"), (String)"jclouds-cluster-foo");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("jclouds-cluster-foo"), (String)"cluster-foo");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("jclouds-cluster-foo"), (String)"cluster");
        Assert.assertTrue((boolean)fn.containsGroup("cluster").apply((Object)"jclouds-cluster-foo"));
    }

    public void testSharedNameNoPrefix() {
        FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat fn = new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat("", '_', Suppliers.ofInstance((Object)"123"), this.okValidator);
        Assert.assertEquals((String)fn.sharedNameForGroup("cluster"), (String)"cluster");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("cluster"), (String)"cluster");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("cluster"), null);
        Assert.assertTrue((boolean)fn.containsGroup("cluster").apply((Object)"cluster"));
    }

    public void testNextNameNoPrefix() {
        FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat fn = new FormatSharedNamesAndAppendUniqueStringToThoseWhichRepeat("", '_', Suppliers.ofInstance((Object)"123"), this.okValidator);
        Assert.assertEquals((String)fn.uniqueNameForGroup("cluster"), (String)"cluster_123");
        Assert.assertEquals((String)fn.groupInSharedNameOrNull("cluster_123"), (String)"cluster_123");
        Assert.assertEquals((String)fn.groupInUniqueNameOrNull("cluster_123"), (String)"cluster");
        Assert.assertTrue((boolean)fn.containsGroup("cluster").apply((Object)"cluster_123"));
    }
}

