/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.options;

import java.io.IOException;
import org.jclouds.compute.options.TemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TemplateOptionsTest {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinstallPrivateKeyBadFormat() {
        TemplateOptions options = new TemplateOptions();
        options.installPrivateKey("whompy");
    }

    @Test
    public void testinstallPrivateKey() throws IOException {
        TemplateOptions options = new TemplateOptions();
        options.installPrivateKey("-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.toString(), (String)"{privateKeyPresent=true}");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test
    public void testNullinstallPrivateKey() {
        TemplateOptions options = new TemplateOptions();
        Assert.assertEquals((String)options.getPrivateKey(), null);
    }

    @Test
    public void testinstallPrivateKeyStatic() throws IOException {
        TemplateOptions options = TemplateOptions.Builder.installPrivateKey((String)"-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testinstallPrivateKeyNPE() {
        TemplateOptions.Builder.installPrivateKey((String)null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testauthorizePublicKeyBadFormat() {
        TemplateOptions options = new TemplateOptions();
        options.authorizePublicKey("whompy");
    }

    @Test
    public void testauthorizePublicKey() throws IOException {
        TemplateOptions options = new TemplateOptions();
        options.authorizePublicKey("ssh-rsa");
        Assert.assertEquals((String)options.toString(), (String)"{publicKeyPresent=true}");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test
    public void testNullauthorizePublicKey() {
        TemplateOptions options = new TemplateOptions();
        Assert.assertEquals((String)options.getPublicKey(), null);
    }

    @Test
    public void testauthorizePublicKeyStatic() throws IOException {
        TemplateOptions options = TemplateOptions.Builder.authorizePublicKey((String)"ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testauthorizePublicKeyNPE() {
        TemplateOptions.Builder.authorizePublicKey((String)null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testblockOnPortBadFormat() {
        TemplateOptions options = new TemplateOptions();
        options.blockOnPort(-1, -1);
    }

    @Test
    public void testblockOnPort() {
        TemplateOptions options = new TemplateOptions();
        options.blockOnPort(22, 30);
        Assert.assertEquals((String)options.toString(), (String)"{blockOnPort:seconds=22:30}");
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test
    public void testNullblockOnPort() {
        TemplateOptions options = new TemplateOptions();
        Assert.assertEquals((int)options.getPort(), (int)-1);
        Assert.assertEquals((int)options.getSeconds(), (int)-1);
    }

    @Test
    public void testblockOnPortStatic() {
        TemplateOptions options = TemplateOptions.Builder.blockOnPort((int)22, (int)30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinboundPortsBadFormat() {
        TemplateOptions options = new TemplateOptions();
        options.inboundPorts(new int[]{-1, -1});
    }

    @Test
    public void testinboundPorts() {
        TemplateOptions options = new TemplateOptions();
        options.inboundPorts(new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }

    @Test
    public void testDefaultOpen22() {
        TemplateOptions options = new TemplateOptions();
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
    }

    @Test
    public void testinboundPortsStatic() {
        TemplateOptions options = TemplateOptions.Builder.inboundPorts((int[])new int[]{22, 30});
        Assert.assertEquals((String)options.toString(), (String)"{inboundPorts=[22, 30]}");
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }

    @Test
    public void testblockUntilRunningDefault() {
        TemplateOptions options = new TemplateOptions();
        Assert.assertEquals((String)options.toString(), (String)"{}");
        Assert.assertEquals((boolean)options.shouldBlockUntilRunning(), (boolean)true);
    }

    @Test
    public void testblockUntilRunning() {
        TemplateOptions options = new TemplateOptions();
        options.blockUntilRunning(false);
        Assert.assertEquals((String)options.toString(), (String)"{blockUntilRunning=false}");
        Assert.assertEquals((boolean)options.shouldBlockUntilRunning(), (boolean)false);
    }

    @Test
    public void testBlockUntilRunningUnsetsBlockOnPort() {
        TemplateOptions options = new TemplateOptions();
        options.blockOnPort(22, 30);
        options.blockUntilRunning(false);
        Assert.assertEquals((boolean)options.shouldBlockUntilRunning(), (boolean)false);
        Assert.assertEquals((int)options.getPort(), (int)-1);
        Assert.assertEquals((int)options.getSeconds(), (int)-1);
    }

    @Test
    public void testblockUntilRunningStatic() {
        TemplateOptions options = TemplateOptions.Builder.blockUntilRunning((boolean)false);
        Assert.assertEquals((boolean)options.shouldBlockUntilRunning(), (boolean)false);
    }
}

