/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import org.jclouds.cim.OSType;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.predicates.OperatingSystemPredicates;
import org.testng.annotations.Test;

@Test
public class OperatingSystemPredicatesTest {
    public void testCIMCENTOSDoesntSupportApt() {
        assert (!OperatingSystemPredicates.supportsApt().apply((Object)new CIMOperatingSystem(OSType.CENTOS, "", null, "description")));
        assert (!OperatingSystemPredicates.supportsApt().apply((Object)new CIMOperatingSystem(OSType.CENTOS_64, "", null, "description")));
    }

    public void testCIMRHELDoesntSupportApt() {
        assert (!OperatingSystemPredicates.supportsApt().apply((Object)new CIMOperatingSystem(OSType.RHEL, "", null, "description")));
        assert (!OperatingSystemPredicates.supportsApt().apply((Object)new CIMOperatingSystem(OSType.RHEL_64, "", null, "description")));
    }

    public void testCIMDEBIANSupportsApt() {
        assert (OperatingSystemPredicates.supportsApt().apply((Object)new CIMOperatingSystem(OSType.DEBIAN, "", null, "description")));
        assert (OperatingSystemPredicates.supportsApt().apply((Object)new CIMOperatingSystem(OSType.DEBIAN_64, "", null, "description")));
    }

    public void testCIMUBUNTUSupportsApt() {
        assert (OperatingSystemPredicates.supportsApt().apply((Object)new CIMOperatingSystem(OSType.UBUNTU, "", null, "description")));
        assert (OperatingSystemPredicates.supportsApt().apply((Object)new CIMOperatingSystem(OSType.UBUNTU_64, "", null, "description")));
    }

    public void testUbuntuNameSupportsApt() {
        assert (OperatingSystemPredicates.supportsApt().apply((Object)new OperatingSystem(null, "Ubuntu", "", null, "description", false)));
    }

    public void testCIMCENTOSSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new CIMOperatingSystem(OSType.CENTOS, "", null, "description")));
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new CIMOperatingSystem(OSType.CENTOS_64, "", null, "description")));
    }

    public void testCIMRHELSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new CIMOperatingSystem(OSType.RHEL, "", null, "description")));
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new CIMOperatingSystem(OSType.RHEL_64, "", null, "description")));
    }

    public void testCIMDEBIANDoesntSupportYum() {
        assert (!OperatingSystemPredicates.supportsYum().apply((Object)new CIMOperatingSystem(OSType.DEBIAN, "", null, "description")));
        assert (!OperatingSystemPredicates.supportsYum().apply((Object)new CIMOperatingSystem(OSType.DEBIAN_64, "", null, "description")));
    }

    public void testCIMUBUNTUDoesntSupportYum() {
        assert (!OperatingSystemPredicates.supportsYum().apply((Object)new CIMOperatingSystem(OSType.UBUNTU, "", null, "description")));
        assert (!OperatingSystemPredicates.supportsYum().apply((Object)new CIMOperatingSystem(OSType.UBUNTU_64, "", null, "description")));
    }

    public void testSuseTypeSupportsZypper() {
        assert (OperatingSystemPredicates.supportsZypper().apply((Object)new OperatingSystem(OsFamily.SUSE, null, "", null, "description", false)));
    }

    public void testSuseDescriptionSupportsZypper() {
        assert (OperatingSystemPredicates.supportsZypper().apply((Object)new OperatingSystem(null, "", null, null, "Suse", false)));
    }

    public void testSuseNameSupportsZypper() {
        assert (OperatingSystemPredicates.supportsZypper().apply((Object)new OperatingSystem(null, "Suse", "", null, "description", false)));
    }

    public void testCentosTypeSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(OsFamily.CENTOS, null, "", null, "description", false)));
    }

    public void testAmzTypeSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(OsFamily.AMZN_LINUX, null, "", null, "description", false)));
    }

    public void testRhelTypeSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(OsFamily.RHEL, null, "", null, "description", false)));
    }

    public void testFedoraTypeSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(OsFamily.FEDORA, null, "", null, "description", false)));
    }

    public void testCentosNameSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(null, "Centos", "", null, "description", false)));
    }

    public void testRhelNameSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(null, "RHEL", "", null, "description", false)));
    }

    public void testFedoraNameSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(null, "Fedora", "", null, "description", false)));
    }

    public void testRedHatEnterpriseLinuxNameSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(null, "Red Hat Enterprise Linux", "", null, "description", false)));
    }

    public void testCentosDescriptionSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(null, "", null, null, "Centos", false)));
    }

    public void testRhelDescriptionSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(null, "", null, null, "RHEL", false)));
    }

    public void testFedoraDescriptionSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(null, "", null, null, "Fedora", false)));
    }

    public void testRedHatEnterpriseLinuxDescriptionSupportsYum() {
        assert (OperatingSystemPredicates.supportsYum().apply((Object)new OperatingSystem(null, "", null, null, "Red Hat Enterprise Linux", false)));
    }
}

