/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.Function;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PrioritizeCredentialsFromTemplateTest")
public class PrioritizeCredentialsFromTemplateTest {
    private static final PrioritizeCredentialsFromTemplate fn = new PrioritizeCredentialsFromTemplate((Function)new DefaultCredentialsFromImageOrOverridingCredentials());

    public void testWhenCredentialsNotPresentInImageTemplateOptionsOrParameterReturnNull() {
        Object expected = null;
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn(null);
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template, null), expected);
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{image});
    }

    public void testWhenCredentialsNotPresentInImageTemplateOptionsReturnsFromParameter() {
        LoginCredentials expected = LoginCredentials.builder().user("foo").password("bar").build();
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn(null);
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template, expected), (Object)expected);
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{image});
    }

    public void testWhenCredentialsNotPresentInImageReturnsOneInTemplateOptionsAndNotParameter() {
        LoginCredentials expected = LoginCredentials.builder().user("ubuntu").password("password").build();
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn(null);
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)TemplateOptions.Builder.overrideLoginCredentials((LoginCredentials)expected));
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template, LoginCredentials.builder().user("foo").password("bar").build()), (Object)expected);
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{image});
    }

    public void testWhenCredentialsNotPresentInImageReturnsCredentialFromTemplateOptionsAndUserFromParameter() {
        Credentials expected = new Credentials("ubuntu", "password");
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn(null);
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)TemplateOptions.Builder.overrideLoginUser((String)"ubuntu"));
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template, LoginCredentials.builder().user("foo").password("password").build()), (Object)expected);
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{image});
    }

    public void testWhenCredentialsNotPresentInTemplateOptionsReturnsOneInImageAndNotParameter() {
        LoginCredentials expected = LoginCredentials.builder().user("ubuntu").password("password").build();
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn((Object)expected);
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template, LoginCredentials.builder().user("foo").password("bar").build()), (Object)expected);
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{image});
    }

    public void testWhenCredentialsPresentInImageOverridesIdentityFromCredentialsInTemplateOptionsAndNotParameter() {
        Credentials expected = new Credentials("ubuntu", "password");
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn((Object)LoginCredentials.builder().user("ubuntu").password("password").build());
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)TemplateOptions.Builder.overrideLoginUser((String)"ubuntu"));
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template, LoginCredentials.builder().user("foo").password("bar").build()), (Object)expected);
        EasyMock.verify((Object[])new Object[]{template, image});
    }

    public void testWhenCredentialsPresentInImageOverridesCredentialFromCredentialsInTemplateOptionsAndNotParameter() {
        LoginCredentials expected = LoginCredentials.builder().user("ubuntu").password("password").build();
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn((Object)LoginCredentials.builder().user("ubuntu").password("password2").build());
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)TemplateOptions.Builder.overrideLoginPassword((String)"password"));
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template, LoginCredentials.builder().user("foo").password("bar").build()), (Object)expected);
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{image});
    }
}

