/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.ComputeMetadataIncludingStatus;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ComputeServiceUtilsTest")
public class ComputeServiceUtilsTest {
    Map<org.jclouds.compute.domain.OsFamily, Map<String, String>> map = new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class));

    @Test
    public void testFormatStatusWithBackendStatus() {
        ComputeMetadataIncludingStatus resource = (ComputeMetadataIncludingStatus)EasyMock.createMock(ComputeMetadataIncludingStatus.class);
        EasyMock.expect((Object)resource.getStatus()).andReturn((Object)Image.Status.PENDING);
        EasyMock.expect((Object)resource.getBackendStatus()).andReturn((Object)"queued").anyTimes();
        EasyMock.replay((Object[])new Object[]{resource});
        Assert.assertEquals((String)ComputeServiceUtils.formatStatus((ComputeMetadataIncludingStatus)resource), (String)"PENDING[queued]");
        EasyMock.verify((Object[])new Object[]{resource});
    }

    @Test
    public void testFormatStatusWithoutBackendStatus() {
        ComputeMetadataIncludingStatus resource = (ComputeMetadataIncludingStatus)EasyMock.createMock(ComputeMetadataIncludingStatus.class);
        EasyMock.expect((Object)resource.getStatus()).andReturn((Object)Image.Status.PENDING);
        EasyMock.expect((Object)resource.getBackendStatus()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{resource});
        Assert.assertEquals((String)ComputeServiceUtils.formatStatus((ComputeMetadataIncludingStatus)resource), (String)"PENDING");
        EasyMock.verify((Object[])new Object[]{resource});
    }

    @Test
    public void testMetadataAndTagsAsValuesOfEmptyString() {
        TemplateOptions options = TemplateOptions.Builder.tags((Iterable)ImmutableSet.of((Object)"tag")).userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        Assert.assertEquals((Map)ComputeServiceUtils.metadataAndTagsAsValuesOfEmptyString((TemplateOptions)options), (Map)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"tag", (Object)""));
    }

    @Test
    public void testMetadataAndTagsAsCommaDelimitedValue() {
        TemplateOptions options = TemplateOptions.Builder.tags((Iterable)ImmutableSet.of((Object)"tag")).userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        Assert.assertEquals((Map)ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue((TemplateOptions)options), (Map)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"jclouds_tags", (Object)"tag"));
    }

    @Test
    public void testMetadataAndTagsAsValuesOfEmptyStringNoTags() {
        TemplateOptions options = TemplateOptions.Builder.userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        Assert.assertEquals((Map)ComputeServiceUtils.metadataAndTagsAsValuesOfEmptyString((TemplateOptions)options), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
    }

    @Test
    public void testMetadataAndTagsAsCommaDelimitedValueNoTags() {
        TemplateOptions options = TemplateOptions.Builder.userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        Assert.assertEquals((Map)ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue((TemplateOptions)options), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
    }

    @Test
    public void testParseVersionOrReturnEmptyStringUbuntu1004() {
        Assert.assertEquals((String)ComputeServiceUtils.parseVersionOrReturnEmptyString((org.jclouds.compute.domain.OsFamily)org.jclouds.compute.domain.OsFamily.UBUNTU, (String)"Ubuntu 10.04", this.map), (String)"10.04");
    }

    @Test
    public void testParseVersionOrReturnEmptyStringUbuntu1104() {
        Assert.assertEquals((String)ComputeServiceUtils.parseVersionOrReturnEmptyString((org.jclouds.compute.domain.OsFamily)org.jclouds.compute.domain.OsFamily.UBUNTU, (String)"ubuntu 11.04 server (i386)", this.map), (String)"11.04");
    }

    @Test
    public void testExecHttpResponse() {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://adriancolehappy.s3.amazonaws.com/java/install").addHeader("Host", new String[]{"adriancolehappy.s3.amazonaws.com"})).addHeader("Date", new String[]{"Sun, 12 Sep 2010 08:25:19 GMT"})).addHeader("Authorization", new String[]{"AWS 0ASHDJAS82:JASHFDA="})).build();
        Assert.assertEquals((String)ComputeServiceUtils.execHttpResponse((HttpRequest)request).render(OsFamily.UNIX), (String)"curl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20 -X GET -H \"Host: adriancolehappy.s3.amazonaws.com\" -H \"Date: Sun, 12 Sep 2010 08:25:19 GMT\" -H \"Authorization: AWS 0ASHDJAS82:JASHFDA=\" https://adriancolehappy.s3.amazonaws.com/java/install |(bash)\n");
    }

    @Test
    public void testTarxzpHttpResponse() {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://adriancolehappy.s3.amazonaws.com/java/install").addHeader("Host", new String[]{"adriancolehappy.s3.amazonaws.com"})).addHeader("Date", new String[]{"Sun, 12 Sep 2010 08:25:19 GMT"})).addHeader("Authorization", new String[]{"AWS 0ASHDJAS82:JASHFDA="})).build();
        Assert.assertEquals((String)ComputeServiceUtils.extractTargzIntoDirectory((HttpRequest)request, (String)"/stage/").render(OsFamily.UNIX), (String)"curl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20 -X GET -H \"Host: adriancolehappy.s3.amazonaws.com\" -H \"Date: Sun, 12 Sep 2010 08:25:19 GMT\" -H \"Authorization: AWS 0ASHDJAS82:JASHFDA=\" https://adriancolehappy.s3.amazonaws.com/java/install |(mkdir -p /stage/ &&cd /stage/ &&tar -xpzf -)\n");
    }

    @Test
    public void testGetPortRangesFromList() {
        HashMap portRanges = Maps.newHashMap();
        portRanges.put(5, 7);
        portRanges.put(10, 11);
        portRanges.put(20, 20);
        Assert.assertEquals((Map)portRanges, (Map)ComputeServiceUtils.getPortRangesFromList((int[])new int[]{5, 6, 7, 10, 11, 20}));
    }
}

