/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.ovf.Disk;
import org.jclouds.ovf.DiskSection;
import org.jclouds.ovf.xml.DiskSectionHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DiskSectionHandlerTest {
    public void test() {
        InputStream is = this.getClass().getResourceAsStream("/disksection.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        DiskSection result = (DiskSection)factory.create((ParseSax.HandlerWithResult)injector.getInstance(DiskSectionHandler.class)).parse(is);
        Assert.assertEquals((String)result.toString(), (String)DiskSection.builder().info("Describes the set of virtual disks").disk(Disk.builder().id("vmdisk1").fileRef("file1").capacity(Long.valueOf(0x200000000L)).populatedSize(Long.valueOf(3549324972L)).format(URI.create("http://www.vmware.com/interfaces/specifications/vmdk.html#sparse")).build()).disk(Disk.builder().id("vmdisk2").capacity(Long.valueOf(0x20000000L)).build()).disk(Disk.builder().id("vmdisk3").capacityAllocationUnits("byte * 2^30").build()).build().toString());
    }
}

