/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.ovf.ProductSection;
import org.jclouds.ovf.Property;
import org.jclouds.ovf.xml.ProductSectionHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ProductSectionHandlerTest {
    public void test() {
        InputStream is = this.getClass().getResourceAsStream("/productsection.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        ProductSection result = (ProductSection)factory.create((ParseSax.HandlerWithResult)injector.getInstance(ProductSectionHandler.class)).parse(is);
        Assert.assertEquals((String)result.toString(), (String)ProductSection.builder().info("vCenter Information").property(Property.builder().value("false").key("vmwareToolsEnabled").label("VMWare Tools Enabled status").description("VMWare Tools Enabled status").build()).property(Property.builder().value("10.12.46.171").key("vmwareESXHost").label("VMWare ESXHost Ipaddress").description("VMWare ESXHost Ipaddress").build()).property(Property.builder().value("cussl01s01c01alun088bal,cussl01s01c01alun089bal").key("datastores").label("Datastore Name").description("Datastore Name").build()).property(Property.builder().value("[Totalcapacity=1335915184128,UsedCapacity=549755813888]").key("cussl01s01c01alun088bal").label("Datastore Capacity").description("Datastore cussl01s01c01alun088bal Total Capacity, Used Capacity in comma separated").build()).property(Property.builder().value("[Totalcapacity=1335915184129,UsedCapacity=549755813889]").key("cussl01s01c01alun089bal").label("Datastore Capacity").description("Datastore cussl01s01c01alun089bal Total Capacity, Used Capacity in comma separated").build()).property(Property.builder().value("[name=3282176-1949-bal-tier01,ip=0.0.0.0,mac=00:50:56:8c:3f:3c]").key("customerPortprofile").label("customerPortprofile").description("customerPortprofile").build()).property(Property.builder().value("[name=vm-server-mgmt,ip=0.0.0.0,mac=00:50:56:8c:39:75]").key("savvisPortprofile").label("savvisPortprofile").description("savvisPortprofile").build()).build().toString());
    }
}

