/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

public class Network {
    private final String name;
    private final String description;

    public static Builder builder() {
        return new Builder();
    }

    public Network(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Network other = (Network)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "[name=" + this.name + ", description=" + this.description + "]";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static class Builder {
        protected String name;
        protected String description;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Network build() {
            return new Network(this.name, this.description);
        }

        public Builder fromNetwork(Network in) {
            return this.name(in.getName()).description(in.getDescription());
        }
    }
}

