/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.ProductSection;
import org.jclouds.ovf.Property;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ProductSectionHandler
extends SectionHandler<ProductSection, ProductSection.Builder> {
    protected Property.Builder configBuilder = Property.builder();

    @Inject
    public ProductSectionHandler(Provider<ProductSection.Builder> builderProvider) {
        super(builderProvider);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Property")) {
            this.configBuilder.key((String)attributes.get("key"));
            this.configBuilder.value((String)attributes.get("value"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Info")) {
            ((ProductSection.Builder)this.builder).info(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Label")) {
            this.configBuilder.label(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
            this.configBuilder.description(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Property")) {
            try {
                ((ProductSection.Builder)this.builder).property(this.configBuilder.build());
            }
            finally {
                this.configBuilder = Property.builder();
            }
        }
        super.endElement(uri, localName, qName);
    }
}

