/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.PagedIterable;
import org.jclouds.collect.PagedIterables;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="PagedIterablesTest")
public class PagedIterablesTest {
    @Test
    public void testSinglePageResultReturnsSame() {
        IterableWithMarker initial = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"));
        Function markerToNext = (Function)EasyMock.createMock(Function.class);
        EasyMock.replay((Object[])new Object[]{markerToNext});
        PagedIterable iterable = PagedIterables.advance((IterableWithMarker)initial, (Function)markerToNext);
        Assert.assertSame((Object)iterable.get(0), (Object)initial);
        EasyMock.verify((Object[])new Object[]{markerToNext});
    }

    @Test
    public void testConcatPage3Pages() {
        IterableWithMarker initial = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"MARKER1");
        Function markerToNext = (Function)EasyMock.createMock(Function.class);
        EasyMock.expect((Object)markerToNext.apply((Object)"MARKER1")).andReturn((Object)IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"boo", (Object)"baz"), (Object)"MARKER2"));
        EasyMock.expect((Object)markerToNext.apply((Object)"MARKER2")).andReturn((Object)IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"ham", (Object)"cheeze"), null));
        EasyMock.replay((Object[])new Object[]{markerToNext});
        PagedIterable iterable = PagedIterables.advance((IterableWithMarker)initial, (Function)markerToNext);
        Assert.assertEquals((Set)iterable.concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"boo", (Object)"baz", (Object)"ham", (Object)"cheeze", (Object[])new String[0]));
        EasyMock.verify((Object[])new Object[]{markerToNext});
    }
}

