/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.Invokable;
import java.lang.reflect.Method;
import java.util.Set;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="Arg0ToPagedIterableTest")
public class Arg0ToPagedIterableTest {
    @Test
    public void testWhenNextMarkerAbsentDoesntAdvance() {
        GeneratedHttpRequest request = this.args((ImmutableList<Object>)ImmutableList.of());
        TestArg0 converter = new TestArg0(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArg0(Optional<Object> arg0) {
                Assert.fail();
                return null;
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"))).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar"));
    }

    @Test
    public void testWhenNextMarkerPresentButNoArgsMarkerToNextForArg0ParamIsAbsent() {
        GeneratedHttpRequest request = this.args((ImmutableList<Object>)ImmutableList.of());
        final IterableWithMarker next = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"baz"));
        TestArg0 converter = new TestArg0(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArg0(Optional<Object> arg0) {
                Assert.assertEquals(arg0, (Object)Optional.absent());
                return Functions.constant((Object)next);
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"marker")).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
    }

    @Test
    public void testWhenNextMarkerPresentWithArgsMarkerToNextForArg0ParamIsPresent() {
        GeneratedHttpRequest request = this.args((ImmutableList<Object>)ImmutableList.of((Object)"path"));
        final IterableWithMarker next = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"baz"));
        TestArg0 converter = new TestArg0(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArg0(Optional<Object> arg0) {
                Assert.assertEquals(arg0, (Object)Optional.of((Object)"path"));
                return Functions.constant((Object)next);
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"marker")).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
    }

    private GeneratedHttpRequest args(ImmutableList<Object> args) {
        try {
            return ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).endpoint("http://localhost")).invocation(Invocation.create((Invokable)Invokable.from((Method)String.class.getMethod("toString", new Class[0])), args)).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Test
    public void testFromCallerWhenNextMarkerPresentButNoArgsMarkerToNextForArg0ParamIsAbsent() {
        GeneratedHttpRequest request = this.callerArgs((ImmutableList<Object>)ImmutableList.of());
        final IterableWithMarker next = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"baz"));
        TestCallerArg0 converter = new TestCallerArg0(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArg0(Optional<Object> arg0) {
                Assert.assertEquals(arg0, (Object)Optional.absent());
                return Functions.constant((Object)next);
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"marker")).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
    }

    @Test
    public void testFromCallerWhenNextMarkerPresentWithArgsMarkerToNextForArg0ParamIsPresent() {
        GeneratedHttpRequest request = this.callerArgs((ImmutableList<Object>)ImmutableList.of((Object)"path"));
        final IterableWithMarker next = IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"baz"));
        TestCallerArg0 converter = new TestCallerArg0(request){

            protected Function<Object, IterableWithMarker<String>> markerToNextForArg0(Optional<Object> arg0) {
                Assert.assertEquals(arg0, (Object)Optional.of((Object)"path"));
                return Functions.constant((Object)next);
            }
        };
        Assert.assertEquals((Set)converter.apply(IterableWithMarkers.from((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)"marker")).concat().toSet(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz"));
    }

    private GeneratedHttpRequest callerArgs(ImmutableList<Object> args) {
        try {
            return ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("GET")).endpoint("http://localhost")).invocation(Invocation.create((Invokable)Invokable.from((Method)String.class.getMethod("toString", new Class[0])))).caller(Invocation.create((Invokable)Invokable.from((Method)String.class.getMethod("toString", new Class[0])), args)).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static abstract class TestCallerArg0
    extends Arg0ToPagedIterable.FromCaller<String, TestCallerArg0> {
        private TestCallerArg0(GeneratedHttpRequest in) {
            this.setContext((HttpRequest)in);
        }
    }

    private static abstract class TestArg0
    extends Arg0ToPagedIterable<String, TestArg0> {
        private TestArg0(GeneratedHttpRequest in) {
            this.setContext((HttpRequest)in);
        }
    }
}

