/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.config;

import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import javax.inject.Inject;
import org.easymock.EasyMock;
import org.jclouds.config.BindApiContextWithWildcardExtendsExplicitAndRawType;
import org.jclouds.config.BindNameToContext;
import org.jclouds.domain.Credentials;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.config.BindProviderMetadataContextAndCredentials;
import org.jclouds.rest.ApiContext;
import org.jclouds.rest.HttpApiMetadata;
import org.jclouds.rest.Utils;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindApiContextWithWildcardExtendsExplicitAndRawTypeTest")
public class BindApiContextWithWildcardExtendsExplicitAndRawTypeTest {
    @Test
    public void testRawAndExplicit() {
        ProviderMetadata md = AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost");
        ExpectedBindings bindings = (ExpectedBindings)this.injectorFor(md).getInstance(ExpectedBindings.class);
        Assert.assertEquals((Object)bindings.raw, (Object)bindings.explicit);
    }

    private Injector injectorFor(ProviderMetadata md) {
        return Guice.createInjector((Module[])new Module[]{new BindNameToContext("test"), new BindProviderMetadataContextAndCredentials(md, Suppliers.ofInstance((Object)new Credentials("user", "pass"))), new BindApiContextWithWildcardExtendsExplicitAndRawType((HttpApiMetadata)HttpApiMetadata.class.cast(md.getApiMetadata())), new BaseRestApiTest.MockModule(), new AbstractModule(){

            protected void configure() {
                this.bind(Utils.class).toInstance(EasyMock.createMock(Utils.class));
                this.bind(IntegrationTestClient.class).toInstance(EasyMock.createMock(IntegrationTestClient.class));
                this.bind(IntegrationTestAsyncClient.class).toInstance(EasyMock.createMock(IntegrationTestAsyncClient.class));
            }
        }});
    }

    @Test
    public void testRawExplicitAndWildCardExtends() {
        ProviderMetadata md = AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost");
        TypeToken<ApiContext<? extends IntegrationTestClient>> wildCardExtendsType = new TypeToken<ApiContext<? extends IntegrationTestClient>>(){
            private static final long serialVersionUID = 1L;
        };
        md = md.toBuilder().apiMetadata(md.getApiMetadata().toBuilder().context((TypeToken)wildCardExtendsType).build()).build();
        ExpectedBindingsWithWildCardExtends bindings = (ExpectedBindingsWithWildCardExtends)this.injectorFor(md).getInstance(ExpectedBindingsWithWildCardExtends.class);
        Assert.assertEquals((Object)bindings.raw, (Object)bindings.explicit);
        Assert.assertEquals((Object)bindings.explicit, (Object)bindings.wildcardExtends);
    }

    private static class ExpectedBindingsWithWildCardExtends {
        private final ApiContext raw;
        private final ApiContext<IntegrationTestClient> explicit;
        private final ApiContext<? extends IntegrationTestClient> wildcardExtends;

        @Inject
        public ExpectedBindingsWithWildCardExtends(ApiContext raw, ApiContext<IntegrationTestClient> explicit, ApiContext<? extends IntegrationTestClient> wildcardExtends) {
            this.raw = raw;
            this.explicit = explicit;
            this.wildcardExtends = wildcardExtends;
        }
    }

    private static class ExpectedBindings {
        private final ApiContext raw;
        private final ApiContext<IntegrationTestClient> explicit;

        @Inject
        public ExpectedBindings(ApiContext raw, ApiContext<IntegrationTestClient> explicit) {
            this.raw = raw;
            this.explicit = explicit;
        }
    }
}

