/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.config;

import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import javax.inject.Inject;
import org.easymock.EasyMock;
import org.jclouds.config.BindNameToContext;
import org.jclouds.config.BindRestContextWithWildcardExtendsExplicitAndRawType;
import org.jclouds.domain.Credentials;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.config.BindProviderMetadataContextAndCredentials;
import org.jclouds.rest.RestApiMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.Utils;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindRestContextWithWildcardExtendsExplicitAndRawTypeTest")
public class BindRestContextWithWildcardExtendsExplicitAndRawTypeTest {
    @Test
    public void testRawAndExplicit() {
        ProviderMetadata md = AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(IntegrationTestClient.class, IntegrationTestAsyncClient.class, (String)"http://localhost");
        ExpectedBindings bindings = (ExpectedBindings)this.injectorFor(md).getInstance(ExpectedBindings.class);
        Assert.assertEquals((Object)bindings.raw, (Object)bindings.explicit);
    }

    private Injector injectorFor(ProviderMetadata md) {
        return Guice.createInjector((Module[])new Module[]{new BindNameToContext("test"), new BindProviderMetadataContextAndCredentials(md, Suppliers.ofInstance((Object)new Credentials("user", "pass"))), new BindRestContextWithWildcardExtendsExplicitAndRawType((RestApiMetadata)RestApiMetadata.class.cast(md.getApiMetadata())), new BaseRestApiTest.MockModule(), new AbstractModule(){

            protected void configure() {
                this.bind(Utils.class).toInstance(EasyMock.createMock(Utils.class));
                this.bind(IntegrationTestClient.class).toInstance(EasyMock.createMock(IntegrationTestClient.class));
                this.bind(IntegrationTestAsyncClient.class).toInstance(EasyMock.createMock(IntegrationTestAsyncClient.class));
            }
        }});
    }

    @Test
    public void testRawExplicitAndWildCardExtends() {
        ProviderMetadata md = AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(IntegrationTestClient.class, IntegrationTestAsyncClient.class, (String)"http://localhost");
        TypeToken<RestContext<? extends IntegrationTestClient, ? extends IntegrationTestAsyncClient>> wildCardExtendsType = new TypeToken<RestContext<? extends IntegrationTestClient, ? extends IntegrationTestAsyncClient>>(){
            private static final long serialVersionUID = 1L;
        };
        md = md.toBuilder().apiMetadata(md.getApiMetadata().toBuilder().context((TypeToken)wildCardExtendsType).build()).build();
        ExpectedBindingsWithWildCardExtends bindings = (ExpectedBindingsWithWildCardExtends)this.injectorFor(md).getInstance(ExpectedBindingsWithWildCardExtends.class);
        Assert.assertEquals((Object)bindings.raw, (Object)bindings.explicit);
        Assert.assertEquals((Object)bindings.explicit, (Object)bindings.wildcardExtends);
    }

    private static class ExpectedBindingsWithWildCardExtends {
        private final RestContext raw;
        private final RestContext<IntegrationTestClient, IntegrationTestAsyncClient> explicit;
        private final RestContext<? extends IntegrationTestClient, ? extends IntegrationTestAsyncClient> wildcardExtends;

        @Inject
        public ExpectedBindingsWithWildCardExtends(RestContext raw, RestContext<IntegrationTestClient, IntegrationTestAsyncClient> explicit, RestContext<? extends IntegrationTestClient, ? extends IntegrationTestAsyncClient> wildcardExtends) {
            this.raw = raw;
            this.explicit = explicit;
            this.wildcardExtends = wildcardExtends;
        }
    }

    private static class ExpectedBindings {
        private final RestContext raw;
        private final RestContext<IntegrationTestClient, IntegrationTestAsyncClient> explicit;

        @Inject
        public ExpectedBindings(RestContext raw, RestContext<IntegrationTestClient, IntegrationTestAsyncClient> explicit) {
            this.raw = raw;
            this.explicit = explicit;
        }
    }
}

