/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import com.google.common.base.Optional;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="LoginCredentialsTest")
public class LoginCredentialsTest {
    public void testPasswordSetsPrivateKeyToAbsentWhenUnset() {
        LoginCredentials toTest = LoginCredentials.builder().user("user").password("password").build();
        Assert.assertEquals((Object)toTest.getOptionalPassword(), (Object)Optional.of((Object)"password"));
        Assert.assertEquals((Object)toTest.getOptionalPrivateKey(), (Object)Optional.absent());
    }

    public void testPasswordLeavesPrivateKeyAloneWhenSet() {
        LoginCredentials toTest = LoginCredentials.builder().user("user").privateKey("key").password("password").build();
        Assert.assertEquals((Object)toTest.getOptionalPassword(), (Object)Optional.of((Object)"password"));
        Assert.assertEquals((Object)toTest.getOptionalPrivateKey(), (Object)Optional.of((Object)"key"));
    }

    public void testPrivateKeySetsPasswordToAbsentWhenUnset() {
        LoginCredentials toTest = LoginCredentials.builder().user("user").privateKey("key").build();
        Assert.assertEquals((Object)toTest.getOptionalPassword(), (Object)Optional.absent());
        Assert.assertEquals((Object)toTest.getOptionalPrivateKey(), (Object)Optional.of((Object)"key"));
    }

    public void testPrivateKeyLeavesPasswordAloneWhenSet() {
        LoginCredentials toTest = LoginCredentials.builder().user("user").password("password").privateKey("key").build();
        Assert.assertEquals((Object)toTest.getOptionalPassword(), (Object)Optional.of((Object)"password"));
        Assert.assertEquals((Object)toTest.getOptionalPrivateKey(), (Object)Optional.of((Object)"key"));
    }
}

