/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.http.BaseJettyTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.options.GetOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.util.Strings2;
import org.jclouds.util.Throwables2;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(threadPoolSize=10, groups={"integration"})
public abstract class BaseHttpCommandExecutorServiceIntegrationTest
extends BaseJettyTest {
    @Test(invocationCount=25, timeOut=5000L)
    public void testRequestFilter() {
        Assert.assertEquals((String)this.client.downloadFilter("", "filterme").trim(), (String)"test");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testGetStringWithHeader() {
        Assert.assertEquals((String)this.client.download("", "test").trim(), (String)"test");
    }

    @Test(invocationCount=1, timeOut=5000L)
    public void testAlternateMethod() {
        Assert.assertEquals((String)this.client.rowdy("").trim(), (String)"<foo><bar>whoppers</bar></foo>");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testGetString() {
        Assert.assertEquals((String)this.client.download("").trim(), (String)"<foo><bar>whoppers</bar></foo>");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testGetStringViaRequest() throws IOException {
        HttpResponse getStringResponse = this.client.invoke(HttpRequest.builder().method("GET").endpoint(String.format("http://localhost:%d/objects/", this.testPort)).build());
        Assert.assertEquals((String)Strings2.toString((InputSupplier)getStringResponse.getPayload()).trim(), (String)"<foo><bar>whoppers</bar></foo>");
    }

    @DataProvider(name="gets")
    public Object[][] createData() {
        return new Object[][]{{"object"}, {"/path"}, {"sp ace"}, {"unic\u20aade"}, {"qu?stion"}};
    }

    @Test(invocationCount=5, timeOut=5000L, dataProvider="gets")
    public void testGetStringSynch(String uri) {
        Assert.assertEquals((String)this.client.synch(uri).trim(), (String)"<foo><bar>whoppers</bar></foo>");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testGetException() {
        Assert.assertEquals((String)this.client.downloadException("", (HttpRequestOptions)GetOptions.Builder.tail((long)1L)).trim(), (String)"foo");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testGetSynchException() {
        Assert.assertEquals((String)this.client.synchException("", "").trim(), (String)"foo");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testGetStringRedirect() {
        Assert.assertEquals((String)this.client.download("redirect").trim(), (String)"<foo><bar>chubbs</bar></foo>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(invocationCount=100, timeOut=5000L)
    public void testGetBigFile() throws IOException {
        InputStream input = this.getConsitution();
        try {
            this.assertValidMd5(input);
        }
        catch (RuntimeException e) {
            Closeables.closeQuietly((Closeable)input);
            if (Throwables2.getFirstThrowableOfType((Throwable)e, IOException.class) != null) {
                input = this.getConsitution();
                this.assertValidMd5(input);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)input);
        }
    }

    private void assertValidMd5(final InputStream input) throws IOException {
        Assert.assertEquals((String)BaseEncoding.base64().encode(new ByteSource(){

            public InputStream openStream() {
                return input;
            }
        }.hash(Hashing.md5()).asBytes()), (String)this.md5);
    }

    private InputStream getConsitution() throws MalformedURLException, IOException {
        URI constitutionUri = URI.create(String.format("http://localhost:%d/101constitutions", this.testPort));
        return constitutionUri.toURL().openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(invocationCount=1)
    public void testUploadBigFile() throws IOException {
        String filename = "jclouds";
        File f = null;
        try {
            f = File.createTempFile(filename, "tmp");
            f.deleteOnExit();
            long length = (long)((double)Runtime.getRuntime().freeMemory() * 1.1);
            MessageDigest digester = this.md5Digest();
            CharSink fileSink = Files.asCharSink((File)f, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
            Writer out = null;
            try {
                out = fileSink.openStream();
                for (long i = 0L; i < length; ++i) {
                    out.append('a');
                    digester.update((byte)97);
                }
                out.flush();
            }
            finally {
                Closeables.closeQuietly((Closeable)out);
            }
            FilePayload payload = Payloads.newFilePayload((File)f);
            byte[] digest = digester.digest();
            payload.getContentMetadata().setContentMD5(digest);
            Multimap<String, String> headers = this.client.postPayloadAndReturnHeaders("", (Payload)payload);
            Assert.assertEquals((Collection)headers.get((Object)"x-Content-MD5"), (Collection)ImmutableList.of((Object)BaseEncoding.base64().encode(digest)));
            payload.release();
        }
        finally {
            if (f != null && f.exists()) {
                f.delete();
            }
        }
    }

    private MessageDigest md5Digest() throws AssertionError {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testPost() {
        Assert.assertEquals((String)this.client.post("", "foo").trim(), (String)"fooPOST");
    }

    @Test(invocationCount=1, timeOut=5000L)
    public void testPostAsInputStream() {
        AtomicInteger postFailures = new AtomicInteger();
        for (int i = 0; i < 5; ++i) {
            try {
                Assert.assertEquals((String)this.client.postAsInputStream("", "foo").trim(), (String)"fooPOST");
                continue;
            }
            catch (Exception e) {
                postFailures.incrementAndGet();
            }
        }
        Assert.assertTrue((postFailures.get() > 0 ? 1 : 0) != 0, (String)"expected failures");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testPostBinder() {
        Assert.assertEquals((String)this.client.postJson("", "foo").trim(), (String)"{\"key\":\"foo\"}POST");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testPostContentDisposition() {
        StringPayload payload = Payloads.newStringPayload((String)"foo");
        payload.getContentMetadata().setContentDisposition("attachment; filename=photo.jpg");
        Multimap<String, String> headers = this.client.postPayloadAndReturnHeaders("", (Payload)payload);
        Assert.assertEquals((Collection)headers.get((Object)"x-Content-Disposition"), (Collection)ImmutableList.of((Object)"attachment; filename=photo.jpg"));
        payload.release();
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testPostContentEncoding() {
        StringPayload payload = Payloads.newStringPayload((String)"foo");
        payload.getContentMetadata().setContentEncoding("gzip");
        Multimap<String, String> headers = this.client.postPayloadAndReturnHeaders("", (Payload)payload);
        Assert.assertEquals((Collection)headers.get((Object)"x-Content-Encoding"), (Collection)ImmutableList.of((Object)"gzip"));
        payload.release();
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testPostContentLanguage() {
        StringPayload payload = Payloads.newStringPayload((String)"foo");
        payload.getContentMetadata().setContentLanguage("mi, en");
        Multimap<String, String> headers = this.client.postPayloadAndReturnHeaders("", (Payload)payload);
        Assert.assertEquals((Collection)headers.get((Object)"x-Content-Language"), (Collection)ImmutableList.of((Object)"mi, en"));
        payload.release();
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testPut() {
        Assert.assertEquals((String)this.client.upload("", "foo").trim(), (String)"fooPUT");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testPutRedirect() {
        Assert.assertEquals((String)this.client.upload("redirect", "foo").trim(), (String)"fooPUTREDIRECT");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testHead() {
        Assert.assertTrue((boolean)this.client.exists(""), (String)"head returned false");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testGetAndParseSax() {
        Assert.assertEquals((String)this.client.downloadAndParse(""), (String)"whoppers");
    }

    @Test(invocationCount=5, timeOut=5000L)
    public void testZeroLengthPut() {
        this.client.putNothing("");
    }
}

