/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;

public abstract class BaseHttpErrorHandlerTest {
    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }

    protected abstract Class<? extends HttpErrorHandler> getHandlerClass();

    protected void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, null, content, expected);
    }

    protected void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        HttpErrorHandler function = (HttpErrorHandler)Guice.createInjector((Module[])new Module[]{new SaxParserModule()}).getInstance(this.getHandlerClass());
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        if (contentType != null) {
            response.getPayload().getContentMetadata().setContentType(contentType);
        }
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(BaseHttpErrorHandlerTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }
}

