/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="HttpMessageTest")
public class HttpMessageTest {
    public void testEndpoint() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://foo").build();
        Assert.assertEquals((Object)request.toBuilder().endpoint("http://bar").build(), (Object)HttpRequest.builder().method("GET").endpoint("http://bar").build());
    }

    public void testReplaceHeader() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://foo").addHeader("foo", new String[]{"bar"})).build();
        Assert.assertEquals((Object)((HttpRequest.Builder)request.toBuilder().replaceHeader("foo", new String[]{"baz"})).build(), (Object)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://foo").addHeader("foo", new String[]{"baz"})).build());
    }

    public void testRemoveHeader() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://foo").addHeader("foo", new String[]{"bar"})).build();
        Assert.assertEquals((Object)((HttpRequest.Builder)request.toBuilder().removeHeader("foo")).build(), (Object)HttpRequest.builder().method("GET").endpoint("http://foo").build());
    }

    public void testReplaceHeaders() {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://foo").addHeader("foo", new String[]{"bar"})).addHeader("rabbit", new String[]{"tree"})).build();
        Assert.assertEquals((Object)((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)ImmutableMultimap.of((Object)"foo", (Object)"bar", (Object)"rabbit", (Object)"robot", (Object)"robert", (Object)"baz"))).build().getHeaders(), (Object)ImmutableMultimap.of((Object)"foo", (Object)"bar", (Object)"rabbit", (Object)"robot", (Object)"robert", (Object)"baz"));
    }

    public void testPutHeadersAddsAnotherValue() {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://foo").addHeader("foo", new String[]{"bar"})).build();
        Assert.assertEquals((Object)((HttpRequest.Builder)request.toBuilder().addHeader("foo", new String[]{"baz"})).build().getHeaders(), (Object)ImmutableMultimap.builder().putAll((Object)"foo", (Object[])new String[]{"bar", "baz"}).build());
    }
}

