/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.io.Closeable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallback;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.util.Strings2;

public interface IntegrationTestAsyncClient
extends Closeable {
    @ROWDY
    @Path(value="/objects/{id}")
    public ListenableFuture<String> rowdy(@PathParam(value="id") String var1);

    @HEAD
    @Path(value="/objects/{id}")
    @org.jclouds.rest.annotations.Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> exists(@PathParam(value="id") String var1);

    @GET
    @Path(value="/objects/{id}")
    public ListenableFuture<String> download(@PathParam(value="id") String var1);

    public ListenableFuture<HttpResponse> invoke(HttpRequest var1);

    @GET
    @Path(value="/{path}")
    public ListenableFuture<String> synch(@PathParam(value="path") String var1);

    @GET
    @Path(value="/objects/{id}")
    @org.jclouds.rest.annotations.Fallback(value=FooOnException.class)
    public ListenableFuture<String> downloadException(@PathParam(value="id") String var1, HttpRequestOptions var2);

    @GET
    @Path(value="/objects/{id}")
    @org.jclouds.rest.annotations.Fallback(value=FooOnException.class)
    public ListenableFuture<String> synchException(@PathParam(value="id") String var1, @HeaderParam(value="Range") String var2);

    @PUT
    @Path(value="/objects/{id}")
    public ListenableFuture<String> upload(@PathParam(value="id") String var1, @BinderParam(value=BindToStringPayload.class) String var2);

    @POST
    @Path(value="/objects/{id}")
    public ListenableFuture<String> post(@PathParam(value="id") String var1, @BinderParam(value=BindToStringPayload.class) String var2);

    @POST
    @Path(value="/objects/{id}")
    public ListenableFuture<String> postAsInputStream(@PathParam(value="id") String var1, @BinderParam(value=BindToInputStreamPayload.class) String var2);

    @POST
    @Path(value="/objects/{id}")
    @ResponseParser(value=ResponsePayload.class)
    public ListenableFuture<Multimap<String, String>> postPayloadAndReturnHeaders(@PathParam(value="id") String var1, Payload var2);

    @POST
    @Path(value="/objects/{id}")
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<String> postJson(@PathParam(value="id") String var1, @PayloadParam(value="key") String var2);

    @GET
    @Path(value="/objects/{id}")
    @RequestFilters(value={Filter.class})
    public ListenableFuture<String> downloadFilter(@PathParam(value="id") String var1, @HeaderParam(value="filterme") String var2);

    @GET
    @Path(value="/objects/{id}")
    public ListenableFuture<String> download(@PathParam(value="id") String var1, @HeaderParam(value="test") String var2);

    @GET
    @Path(value="/objects/{id}")
    @XMLResponseParser(value=BarHandler.class)
    public ListenableFuture<String> downloadAndParse(@PathParam(value="id") String var1);

    @PUT
    @Path(value="/objects/{id}")
    public ListenableFuture<Void> putNothing(@PathParam(value="id") String var1);

    @Provides
    public StringBuilder newStringBuilder();

    public static class BarHandler
    extends ParseSax.HandlerWithResult<String> {
        private String bar = null;
        private StringBuilder currentText = new StringBuilder();

        public void endElement(String uri, String name, String qName) {
            if (qName.equals("bar")) {
                this.bar = this.currentText.toString();
            }
            this.currentText = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) {
            this.currentText.append(ch, start, length);
        }

        public String getResult() {
            return this.bar;
        }
    }

    public static class Filter
    implements HttpRequestFilter {
        public HttpRequest filter(HttpRequest request) throws HttpException {
            if (request.getHeaders().containsKey((Object)"filterme")) {
                request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("test", new String[]{"test"})).build();
            }
            return request;
        }
    }

    @Singleton
    public static class ResponsePayload
    implements Function<HttpResponse, Multimap<String, String>> {
        public Multimap<String, String> apply(HttpResponse from) {
            return from.getHeaders();
        }
    }

    public static class BindToInputStreamPayload
    extends BindToStringPayload {
        public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
            request.setPayload(Strings2.toInputStream((String)payload.toString()));
            request.getPayload().getContentMetadata().setContentLength(Long.valueOf(payload.toString().getBytes().length));
            return request;
        }
    }

    public static class FooOnException
    implements Fallback<String> {
        public ListenableFuture<String> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)"foo");
        }

        public String createOrPropagate(Throwable t) throws Exception {
            return "foo";
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @HttpMethod(value="ROWDY")
    public static @interface ROWDY {
    }
}

