/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.filters;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import java.util.Arrays;
import java.util.Deque;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.filters.BasicAuthentication;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BasicAuthenticationTest {
    private static final Credentials credential1 = new Credentials("Aladdin", "open sesame");
    private static final Credentials credential2 = new Credentials("Little", "Mermaid");

    public void testAuth() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        request = new BasicAuthentication(Suppliers.ofInstance((Object)credential1)).filter(request);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("Authorization"), (String)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        request = new BasicAuthentication(Suppliers.ofInstance((Object)credential2)).filter(request);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("Authorization"), (String)"Basic TGl0dGxlOk1lcm1haWQ=");
    }

    public void testAuthWithRuntimePasswordChange() {
        Supplier<Credentials> credentialRotation = new Supplier<Credentials>(){
            Deque<Credentials> rotation = Queues.newArrayDeque(Arrays.asList(BasicAuthenticationTest.access$000(), BasicAuthenticationTest.access$100()));

            public Credentials get() {
                return this.rotation.poll();
            }
        };
        BasicAuthentication filter = new BasicAuthentication((Supplier)credentialRotation);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        request = filter.filter(request);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("Authorization"), (String)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        request = filter.filter(request);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("Authorization"), (String)"Basic TGl0dGxlOk1lcm1haWQ=");
    }

    static /* synthetic */ Credentials access$000() {
        return credential1;
    }

    static /* synthetic */ Credentials access$100() {
        return credential2;
    }
}

