/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.easymock.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.utils.TestUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

@Test(groups={"unit"}, testName="ParseSaxTest")
public class ParseSaxTest
extends BaseHandlerTest {
    ParseSax<String> createParser() {
        return this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TestHandler.class));
    }

    @DataProvider
    public Object[][] runUnderJava7() {
        return TestUtils.isJava7() ? TestUtils.SINGLE_NO_ARG_INVOCATION : TestUtils.NO_INVOCATIONS;
    }

    @DataProvider
    public Object[][] ignoreUnderJava7() {
        return TestUtils.isJava7() ? TestUtils.NO_INVOCATIONS : TestUtils.SINGLE_NO_ARG_INVOCATION;
    }

    @Test
    public void testAddDetailsAndPropagateOkWhenRequestWithNoDataAndRuntimeExceptionThrowsOriginalException() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        ParseSax<String> parser = this.createParser();
        RuntimeException input = new RuntimeException("foo");
        try {
            parser.addDetailsAndPropagate(null, (Exception)input);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)e, (Object)input);
        }
    }

    @Test
    public void testAddDetailsAndPropagateOkWhenRequestWithNoDataAndExceptionPropagates() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        ParseSax<String> parser = this.createParser();
        Exception input = new Exception("foo");
        try {
            parser.addDetailsAndPropagate(null, input);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"java.lang.Exception: foo");
            Assert.assertEquals((Object)e.getCause(), (Object)input);
        }
    }

    @Test
    public void testAddDetailsAndPropagateOkWhenRequestIsNotNullAndResponseIsNull() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        ParseSax<String> parser = this.createParser();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://foohost").build();
        Exception input = new Exception("foo");
        try {
            parser.setContext(request);
            parser.addDetailsAndPropagate(null, input);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"request: GET http://foohost HTTP/1.1; cause: java.lang.Exception: foo");
            Assert.assertEquals((Object)e.getCause(), (Object)input);
        }
    }

    @Test
    public void testAddDetailsAndPropagateOkWithValidRequestResponse() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        ParseSax<String> parser = this.createParser();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://foohost").build();
        HttpResponse response = HttpResponse.builder().statusCode(304).message("Not Modified").build();
        Exception input = new Exception("foo");
        try {
            parser.setContext(request);
            parser.addDetailsAndPropagate(response, input);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"request: GET http://foohost HTTP/1.1; response: HTTP/1.1 304 Not Modified; cause: java.lang.Exception: foo");
            Assert.assertEquals((Object)e.getCause(), (Object)input);
        }
    }

    @Test(dataProvider="ignoreUnderJava7", description="see http://code.google.com/p/jclouds/issues/detail?id=795")
    public void testAddDetailsAndPropagateOkWithValidRequestResponseWithSAXParseException() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        ParseSax<String> parser = this.createParser();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://foohost").build();
        HttpResponse response = HttpResponse.builder().statusCode(304).message("Not Modified").build();
        Locator locator = (Locator)EasyMock.createMock(Locator.class);
        EasyMock.expect((Object)locator.getColumnNumber()).andReturn((Object)1);
        EasyMock.expect((Object)locator.getLineNumber()).andReturn((Object)1);
        EasyMock.expect((Object)locator.getPublicId()).andReturn((Object)"publicId");
        EasyMock.expect((Object)locator.getSystemId()).andReturn((Object)"systemId");
        EasyMock.replay((Object[])new Object[]{locator});
        SAXParseException input = new SAXParseException("foo", locator);
        EasyMock.verify((Object[])new Object[]{locator});
        try {
            parser.setContext(request);
            parser.addDetailsAndPropagate(response, (Exception)input);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"request: GET http://foohost HTTP/1.1; response: HTTP/1.1 304 Not Modified; error at 1:1 in document systemId; cause: org.xml.sax.SAXParseException: foo");
            Assert.assertEquals((Object)e.getCause(), (Object)input);
        }
    }

    @Test(dataProvider="runUnderJava7", description="see http://code.google.com/p/jclouds/issues/detail?id=795")
    public void testAddDetailsAndPropagateOkWithValidRequestResponseWithSAXParseException_java7() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        ParseSax<String> parser = this.createParser();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://foohost").build();
        HttpResponse response = HttpResponse.builder().statusCode(304).message("Not Modified").build();
        Locator locator = (Locator)EasyMock.createMock(Locator.class);
        EasyMock.expect((Object)locator.getColumnNumber()).andReturn((Object)1);
        EasyMock.expect((Object)locator.getLineNumber()).andReturn((Object)1);
        EasyMock.expect((Object)locator.getPublicId()).andReturn((Object)"publicId");
        EasyMock.expect((Object)locator.getSystemId()).andReturn((Object)"systemId");
        EasyMock.replay((Object[])new Object[]{locator});
        SAXParseException input = new SAXParseException("foo", locator);
        EasyMock.verify((Object[])new Object[]{locator});
        try {
            parser.setContext(request);
            parser.addDetailsAndPropagate(response, (Exception)input);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"request: GET http://foohost HTTP/1.1; response: HTTP/1.1 304 Not Modified; error at 1:1 in document systemId; cause: org.xml.sax.SAXParseExceptionpublicId: publicId; systemId: systemId; lineNumber: 1; columnNumber: 1; foo");
            Assert.assertEquals((Object)e.getCause(), (Object)input);
        }
    }

    public static class TestHandler
    extends ParseSax.HandlerWithResult<String> {
        public String getResult() {
            return "";
        }
    }
}

