/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseHttpErrorHandlerTest<T extends HttpErrorHandler> {
    protected abstract Class<T> getClassToTest();

    protected void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected, String exceptionMessage) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/xml", content, expected, exceptionMessage);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected, String exceptionMessage) {
        HttpErrorHandler function = (HttpErrorHandler)Guice.createInjector((Module[])new Module[0]).getInstance(this.getClassToTest());
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(BaseHttpErrorHandlerTest.exceptionEq(expected, exceptionMessage));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception exceptionEq(final Class<? extends Exception> in, final String exceptionMessage) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("exceptionEq(");
                buffer.append(in);
                buffer.append(",");
                buffer.append(exceptionMessage);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in && exceptionMessage.equals(((Exception)Exception.class.cast(arg)).getMessage());
            }
        });
        return null;
    }
}

