/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.Invokable;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.json.internal.NamingStrategies;
import org.jclouds.reflect.Reflection2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="NamingStrategiesTest")
public final class NamingStrategiesTest {
    public void testExtractSerializedName() throws Exception {
        NamingStrategies.ExtractSerializedName extractor = new NamingStrategies.ExtractSerializedName();
        Assert.assertEquals((String)extractor.extractName((Annotation)SimpleTest.class.getDeclaredField("a").getAnnotation(SerializedName.class)), (String)"aardvark");
        try {
            extractor.extractName((Annotation)SimpleTest.class.getDeclaredField("b").getAnnotation(SerializedName.class));
            Assert.fail();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            extractor.extractName((Annotation)SimpleTest.class.getDeclaredField("c").getAnnotation(SerializedName.class));
            Assert.fail();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            extractor.extractName((Annotation)SimpleTest.class.getDeclaredField("d").getAnnotation(SerializedName.class));
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testExtractNamed() throws Exception {
        NamingStrategies.ExtractNamed extractor = new NamingStrategies.ExtractNamed();
        try {
            extractor.extractName((Annotation)SimpleTest.class.getDeclaredField("a").getAnnotation(Named.class));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            extractor.extractName((Annotation)SimpleTest.class.getDeclaredField("b").getAnnotation(Named.class));
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((String)extractor.extractName((Annotation)SimpleTest.class.getDeclaredField("c").getAnnotation(Named.class)), (String)"cat");
        Assert.assertEquals((String)extractor.extractName((Annotation)SimpleTest.class.getDeclaredField("d").getAnnotation(Named.class)), (String)"dog");
    }

    public void testAnnotationFieldNamingStrategy() throws Exception {
        NamingStrategies.AnnotationFieldNamingStrategy strategy = new NamingStrategies.AnnotationFieldNamingStrategy((Iterable)ImmutableSet.of((Object)new NamingStrategies.ExtractNamed()));
        Assert.assertNull((Object)strategy.translateName(SimpleTest.class.getDeclaredField("a")));
        Assert.assertNull((Object)strategy.translateName(SimpleTest.class.getDeclaredField("b")));
        Assert.assertEquals((String)strategy.translateName(SimpleTest.class.getDeclaredField("c")), (String)"cat");
        Assert.assertEquals((String)strategy.translateName(SimpleTest.class.getDeclaredField("d")), (String)"dog");
    }

    public void testAnnotationOrNameFieldNamingStrategy() throws Exception {
        NamingStrategies.AnnotationOrNameFieldNamingStrategy strategy = new NamingStrategies.AnnotationOrNameFieldNamingStrategy((Iterable)ImmutableSet.of((Object)new NamingStrategies.ExtractNamed()));
        Assert.assertEquals((String)strategy.translateName(SimpleTest.class.getDeclaredField("a")), (String)"a");
        Assert.assertEquals((String)strategy.translateName(SimpleTest.class.getDeclaredField("b")), (String)"b");
        Assert.assertEquals((String)strategy.translateName(SimpleTest.class.getDeclaredField("c")), (String)"cat");
        Assert.assertEquals((String)strategy.translateName(SimpleTest.class.getDeclaredField("d")), (String)"dog");
    }

    public void testAnnotationConstructorFieldNamingStrategyCPAndNamed() throws Exception {
        NamingStrategies.AnnotationConstructorNamingStrategy strategy = new NamingStrategies.AnnotationConstructorNamingStrategy((Collection)ImmutableSet.of(ConstructorProperties.class), (Iterable)ImmutableSet.of((Object)new NamingStrategies.ExtractNamed()));
        Invokable constructor = strategy.getDeserializer(Reflection2.typeToken(SimpleTest.class));
        Assert.assertNotNull((Object)constructor);
        Assert.assertEquals((int)constructor.getParameters().size(), (int)4);
        Assert.assertEquals((String)strategy.translateName(constructor, 0), (String)"aardvark");
        Assert.assertEquals((String)strategy.translateName(constructor, 1), (String)"bat");
        Assert.assertEquals((String)strategy.translateName(constructor, 2), (String)"coyote");
        Assert.assertEquals((String)strategy.translateName(constructor, 3), (String)"dingo");
        Invokable mixedCtor = strategy.getDeserializer(Reflection2.typeToken(MixedConstructorTest.class));
        Assert.assertNotNull((Object)mixedCtor);
        Assert.assertEquals((int)mixedCtor.getParameters().size(), (int)4);
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 0), (String)"aardvark");
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 1), (String)"bat");
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 2), (String)"cat");
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 3), (String)"dog");
    }

    public void testAnnotationConstructorFieldNamingStrategyCP() throws Exception {
        NamingStrategies.AnnotationConstructorNamingStrategy strategy = new NamingStrategies.AnnotationConstructorNamingStrategy((Collection)ImmutableSet.of(ConstructorProperties.class), (Iterable)ImmutableSet.of());
        Invokable constructor = strategy.getDeserializer(Reflection2.typeToken(SimpleTest.class));
        Assert.assertNotNull((Object)constructor);
        Assert.assertEquals((int)constructor.getParameters().size(), (int)4);
        Assert.assertEquals((String)strategy.translateName(constructor, 0), (String)"aardvark");
        Assert.assertEquals((String)strategy.translateName(constructor, 1), (String)"bat");
        Assert.assertEquals((String)strategy.translateName(constructor, 2), (String)"coyote");
        Assert.assertEquals((String)strategy.translateName(constructor, 3), (String)"dog");
        Invokable mixedCtor = strategy.getDeserializer(Reflection2.typeToken(MixedConstructorTest.class));
        Assert.assertNotNull((Object)mixedCtor);
        Assert.assertEquals((int)mixedCtor.getParameters().size(), (int)4);
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 0), (String)"thiscanbeoverriddenbyNamed");
        Assert.assertNull((Object)strategy.translateName(mixedCtor, 1));
        Assert.assertNull((Object)strategy.translateName(mixedCtor, 2));
        Assert.assertNull((Object)strategy.translateName(mixedCtor, 3));
    }

    public void testAnnotationConstructorFieldNamingStrategyInject() throws Exception {
        NamingStrategies.AnnotationConstructorNamingStrategy strategy = new NamingStrategies.AnnotationConstructorNamingStrategy((Collection)ImmutableSet.of(Inject.class), (Iterable)ImmutableSet.of((Object)new NamingStrategies.ExtractNamed()));
        Invokable constructor = strategy.getDeserializer(Reflection2.typeToken(SimpleTest.class));
        Assert.assertNotNull((Object)constructor);
        Assert.assertEquals((int)constructor.getParameters().size(), (int)5);
        Assert.assertEquals((String)strategy.translateName(constructor, 0), (String)"aa");
        Assert.assertEquals((String)strategy.translateName(constructor, 1), (String)"bb");
        Assert.assertEquals((String)strategy.translateName(constructor, 2), (String)"cc");
        Assert.assertEquals((String)strategy.translateName(constructor, 3), (String)"dd");
        Invokable mixedCtor = strategy.getDeserializer(Reflection2.typeToken(MixedConstructorTest.class));
        Assert.assertNotNull((Object)mixedCtor);
        Assert.assertEquals((int)mixedCtor.getParameters().size(), (int)4);
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 0), (String)"aardvark");
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 1), (String)"bat");
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 2), (String)"cat");
        Assert.assertEquals((String)strategy.translateName(mixedCtor, 3), (String)"dog");
    }

    private static class MixedConstructorTest {
        @Inject
        @ConstructorProperties(value={"thiscanbeoverriddenbyNamed"})
        private MixedConstructorTest(@Named(value="aardvark") String aa, @Named(value="bat") String bb, @Named(value="cat") String cc, @Named(value="dog") String dd) {
        }
    }

    private static class SimpleTest {
        @SerializedName(value="aardvark")
        private String a;
        private String b;
        @Named(value="cat")
        private String c;
        @Named(value="dog")
        private String d;

        @ConstructorProperties(value={"aardvark", "bat", "coyote", "dog"})
        private SimpleTest(String aa, String bb, String cc, @Named(value="dingo") String dd) {
        }

        @Inject
        private SimpleTest(@Named(value="aa") String aa, @Named(value="bb") String bb, @Named(value="cc") String cc, @Named(value="dd") String dd, boolean nothing) {
        }
    }
}

