/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.lifecycle.config;

import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.lifecycle.Closer;
import org.jclouds.lifecycle.config.LifeCycleModule;
import org.testng.annotations.Test;

@Test
public class LifeCycleModuleTest {
    @Test
    void testBindsExecutor() {
        Injector i = this.createInjector();
        assert (i.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads"))) != null);
        assert (i.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.io-worker-threads"))) != null);
    }

    private Injector createInjector() {
        Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.io-worker-threads")).to(1);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.user-threads")).to(1);
            }
        }, new LifeCycleModule(), new ExecutorServiceModule()});
        ((ExecutionList)i.getInstance(ExecutionList.class)).execute();
        return i;
    }

    @Test
    void testBindsCloser() {
        Injector i = this.createInjector();
        assert (i.getInstance(Closer.class) != null);
    }

    @Test
    void testCloserClosesExecutor() throws IOException {
        Injector i = this.createInjector();
        ListeningExecutorService executor = (ListeningExecutorService)i.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads")));
        assert (!executor.isShutdown());
        Closer closer = (Closer)i.getInstance(Closer.class);
        closer.close();
        assert (executor.isShutdown());
    }

    @Test
    void testCloserPreDestroyOrder() throws IOException {
        Injector i = this.createInjector();
        ListeningExecutorService userExecutor = (ListeningExecutorService)i.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads")));
        assert (!userExecutor.isShutdown());
        ListeningExecutorService ioExecutor = (ListeningExecutorService)i.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.io-worker-threads")));
        assert (!ioExecutor.isShutdown());
        Closer closer = (Closer)i.getInstance(Closer.class);
        closer.close();
        assert (userExecutor.isShutdown());
        assert (ioExecutor.isShutdown());
    }

    @Test
    void testPostConstruct() {
        Injector i = this.createInjector().createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(PostConstructable.class);
            }
        }});
        PostConstructable postConstructable = (PostConstructable)i.getInstance(PostConstructable.class);
        assert (postConstructable.isStarted);
    }

    static class PostConstructable {
        boolean isStarted;

        PostConstructable() {
        }

        @PostConstruct
        void start() {
            this.isStarted = true;
        }
    }
}

