/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Set;
import java.util.logging.Logger;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;
import org.jclouds.reflect.Reflection2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseProviderMetadataTest {
    private final ProviderMetadata toTest;
    private final ApiMetadata expectedApi;
    private final Set<TypeToken<? extends View>> views;

    public BaseProviderMetadataTest(ProviderMetadata toTest, ApiMetadata expectedApi) {
        this.toTest = (ProviderMetadata)Preconditions.checkNotNull((Object)toTest, (Object)"toTest must be defined");
        this.expectedApi = (ApiMetadata)Preconditions.checkNotNull((Object)expectedApi, (Object)"expectedApi must be defined");
        this.views = expectedApi.getViews();
    }

    @Test
    public void testWithId() {
        ProviderMetadata providerMetadata = Providers.withId((String)this.toTest.getId());
        Assert.assertEquals((Object)this.toTest, (Object)providerMetadata);
        assert (providerMetadata.getLinkedServices().contains(this.toTest.getId()));
    }

    @Test
    public void testOfApiContains() {
        if (this.expectedApi == null) {
            Logger.getAnonymousLogger().warning("please update your test class");
        }
        ImmutableSet ofApi = ImmutableSet.copyOf((Iterable)Providers.apiMetadataAssignableFrom((TypeToken)Reflection2.typeToken(this.expectedApi.getClass())));
        assert (ofApi.contains((Object)this.toTest)) : String.format("%s not found in %s", this.toTest, ofApi);
    }

    @Test
    public void testTransformableToContains() {
        for (TypeToken<? extends View> view : this.views) {
            ImmutableSet ofType = ImmutableSet.copyOf((Iterable)Providers.viewableAs(view));
            assert (ofType.contains((Object)this.toTest)) : String.format("%s not found in %s for %s", this.toTest, ofType, view);
        }
    }

    @Test
    public void testAllContains() {
        ImmutableSet all = ImmutableSet.copyOf((Iterable)Providers.all());
        assert (all.contains((Object)this.toTest)) : String.format("%s not found in %s", this.toTest, all);
    }
}

