/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.UpdateProviderMetadataFromProperties;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="UpdateProviderMetadataFromPropertiesTest")
public class UpdateProviderMetadataFromPropertiesTest {
    @Test
    public void testProviderMetadataWithUpdatedEndpointUpdatesAndRetainsAllDefaultPropertiesExceptEndpoint() {
        ProviderMetadata md = AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(IntegrationTestClient.class, IntegrationTestAsyncClient.class, (String)"http://localhost");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)md.getDefaultProperties());
        props.setProperty("jclouds.endpoint", "http://nonlocal");
        ProviderMetadata newMd = new UpdateProviderMetadataFromProperties(md).apply(props);
        Assert.assertEquals((String)newMd.getEndpoint(), (String)"http://nonlocal");
        Assert.assertEquals((Map)newMd.getDefaultProperties(), (Map)md.getDefaultProperties());
    }

    @Test
    public void testProviderMetadataWithUpdatedIso3166CodesUpdatesAndRetainsAllDefaultPropertiesExceptIso3166Codes() {
        ProviderMetadata md = AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(IntegrationTestClient.class, IntegrationTestAsyncClient.class, (String)"http://localhost");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)md.getDefaultProperties());
        props.setProperty("jclouds.iso3166-codes", "US-CA");
        ProviderMetadata newMd = new UpdateProviderMetadataFromProperties(md).apply(props);
        Assert.assertEquals((Set)newMd.getIso3166Codes(), (Set)ImmutableSet.of((Object)"US-CA"));
        Assert.assertEquals((Map)newMd.getDefaultProperties(), (Map)md.getDefaultProperties());
    }
}

