/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.ws.rs.PathParam;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.binders.BindMapToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindMapToStringPayloadTest {
    @Test
    public void testCorrect() throws SecurityException, NoSuchMethodException {
        Invokable testPayload = Reflection2.method(TestPayload.class, (String)"testPayload", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().invocation(Invocation.create((Invokable)testPayload, (List)ImmutableList.of((Object)"robot"))).method("POST")).endpoint("http://localhost")).build();
        GeneratedHttpRequest newRequest = (GeneratedHttpRequest)this.binder().bindToRequest((HttpRequest)request, (Map)ImmutableMap.of((Object)"fooble", (Object)"robot"));
        Assert.assertEquals((String)newRequest.getRequestLine(), (String)request.getRequestLine());
        Assert.assertEquals((Object)newRequest.getPayload().getRawContent(), (Object)"name robot");
    }

    @Test
    public void testDecodes() throws SecurityException, NoSuchMethodException {
        Invokable testPayload = Reflection2.method(TestPayload.class, (String)"changeAdminPass", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().invocation(Invocation.create((Invokable)testPayload, (List)ImmutableList.of((Object)"foo"))).method("POST")).endpoint("http://localhost")).build();
        GeneratedHttpRequest newRequest = (GeneratedHttpRequest)this.binder().bindToRequest((HttpRequest)request, (Map)ImmutableMap.of((Object)"adminPass", (Object)"foo"));
        Assert.assertEquals((String)newRequest.getRequestLine(), (String)request.getRequestLine());
        Assert.assertEquals((Object)newRequest.getPayload().getRawContent(), (Object)"{\"changePassword\":{\"adminPass\":\"foo\"}}");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustHavePayloadAnnotation() throws SecurityException, NoSuchMethodException {
        Invokable noPayload = Reflection2.method(TestPayload.class, (String)"noPayload", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().invocation(Invocation.create((Invokable)noPayload, (List)ImmutableList.of((Object)"robot"))).method("POST")).endpoint("http://localhost")).build();
        this.binder().bindToRequest((HttpRequest)request, (Map)ImmutableMap.of((Object)"fooble", (Object)"robot"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeMap() {
        BindMapToStringPayload binder = this.binder();
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        BindMapToStringPayload binder = this.binder();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        binder.bindToRequest(request, null);
    }

    public BindMapToStringPayload binder() {
        return new BindMapToStringPayload();
    }

    static interface TestPayload {
        @Payload(value="name {fooble}")
        public void testPayload(@PathParam(value="foo") String var1);

        public void noPayload(String var1);

        @Payload(value="%7B\"changePassword\":%7B\"adminPass\":\"{adminPass}\"%7D%7D")
        public void changeAdminPass(@PayloadParam(value="adminPass") String var1);
    }
}

