/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jclouds.rest.HttpAsyncClient;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.config.SyncToAsyncHttpInvocationModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class MappedHttpInvocationModuleTest {
    static final Predicate<Map.Entry<Invokable<?, ?>, Invokable<?, ?>>> isHttpInvokable = new Predicate<Map.Entry<Invokable<?, ?>, Invokable<?, ?>>>(){

        public boolean apply(Map.Entry<Invokable<?, ?>, Invokable<?, ?>> in) {
            return in.getKey().getOwnerType().getRawType().equals(HttpClient.class) && in.getValue().getOwnerType().getRawType().equals(HttpAsyncClient.class);
        }
    };

    public void testPutInvokablesWhenInterfacesMatch() {
        Cache cache = CacheBuilder.newBuilder().build();
        SyncToAsyncHttpInvocationModule.putInvokables(Sync.class, Async.class, (Cache)cache);
        Assert.assertEquals((long)cache.size(), (long)1L);
        Invokable sync = (Invokable)cache.asMap().keySet().iterator().next();
        Assert.assertEquals((Object)sync.getOwnerType().getRawType(), Sync.class);
        Assert.assertEquals((String)sync.getName(), (String)"get");
        Assert.assertEquals((Object)sync.getReturnType(), (Object)TypeToken.of(String.class));
        Invokable async = (Invokable)cache.getIfPresent((Object)sync);
        Assert.assertEquals((Object)async.getOwnerType().getRawType(), Async.class);
        Assert.assertEquals((String)async.getName(), (String)"get");
        Assert.assertEquals((Object)async.getReturnType(), (Object)new TypeToken<ListenableFuture<String>>(){
            private static final long serialVersionUID = 1L;
        });
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".* has different typed exceptions than target .*")
    public void testPutInvokablesWhenInterfacesMatchExceptExceptions() {
        Cache cache = CacheBuilder.newBuilder().build();
        SyncToAsyncHttpInvocationModule.putInvokables(Sync.class, AsyncWithException.class, (Cache)cache);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="no such method .*")
    public void testPutInvokablesWhenTargetMethodNotFound() {
        Cache cache = CacheBuilder.newBuilder().build();
        SyncToAsyncHttpInvocationModule.putInvokables(Sync.class, AsyncWithMisnamedMethod.class, (Cache)cache);
    }

    public void testSeedKnownSync2AsyncIncludesHttpClientByDefault() {
        ConcurrentMap cache = SyncToAsyncHttpInvocationModule.seedKnownSync2AsyncInvokables((Map)ImmutableMap.of()).asMap();
        Assert.assertEquals((int)cache.size(), (int)6);
        Assert.assertEquals((Map)Maps.filterEntries((Map)cache, isHttpInvokable), (Map)cache);
    }

    public void testSeedKnownSync2AsyncInvokablesInterfacesMatch() {
        Map cache = SyncToAsyncHttpInvocationModule.seedKnownSync2AsyncInvokables((Map)ImmutableMap.of(Sync.class, Async.class)).asMap();
        Assert.assertEquals((int)cache.size(), (int)7);
        cache = Maps.filterEntries((Map)cache, (Predicate)Predicates.not(isHttpInvokable));
        Assert.assertEquals((int)cache.size(), (int)1);
    }

    private static interface AsyncWithMisnamedMethod {
        public ListenableFuture<String> got();
    }

    private static interface AsyncWithException {
        public ListenableFuture<String> get() throws IOException;
    }

    private static interface Async {
        public ListenableFuture<String> get();
    }

    static interface Sync {
        public String get();
    }
}

