/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.TimeLimiter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.easymock.EasyMock;
import org.jclouds.Fallback;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.config.InvocationConfig;
import org.jclouds.rest.internal.InvokeHttpMethod;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class InvokeHttpMethodTest {
    private Invocation get;
    private HttpRequest getRequest = HttpRequest.builder().method("GET").endpoint("http://get").build();
    private HttpCommand getCommand = new HttpCommand(this.getRequest);
    private Function<Invocation, HttpRequest> toRequest;
    private Function<HttpRequest, Function<HttpResponse, ?>> transformerForRequest = (Function)Function.class.cast(Functions.constant((Object)Functions.identity()));
    private HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload("foo")).build();
    private HttpCommandExecutorService http;
    private TimeLimiter timeLimiter;
    private Fallback fallback;
    private InvocationConfig config;
    private InvokeHttpMethod invokeHttpMethod;
    private ListenableFuture<HttpResponse> future;
    private HttpResponse fallbackResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload("bar")).build();

    @BeforeClass
    void setupInvocations() throws SecurityException, NoSuchMethodException {
        this.get = Invocation.create((Invokable)Reflection2.method(ThingApi.class, (String)"get", (Class[])new Class[0]), (List)ImmutableList.of());
        this.toRequest = Functions.forMap((Map)ImmutableMap.of((Object)this.get, (Object)this.getRequest));
    }

    @BeforeMethod
    void createMocks() {
        this.http = (HttpCommandExecutorService)EasyMock.createMock(HttpCommandExecutorService.class);
        this.timeLimiter = (TimeLimiter)EasyMock.createMock(TimeLimiter.class);
        this.fallback = (Fallback)EasyMock.createMock(Fallback.class);
        this.config = (InvocationConfig)EasyMock.createMock(InvocationConfig.class);
        this.future = (ListenableFuture)EasyMock.createMock(ListenableFuture.class);
        this.invokeHttpMethod = new InvokeHttpMethod(this.toRequest, this.http, this.transformerForRequest, this.timeLimiter, this.config);
        EasyMock.expect((Object)this.config.getCommandName(this.get)).andReturn((Object)"ns:get");
        EasyMock.expect((Object)this.config.getFallback(this.get)).andReturn((Object)this.fallback);
    }

    @AfterMethod
    void verifyMocks() {
        EasyMock.verify((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
    }

    public void testMethodWithTimeoutRunsTimeLimiter() throws Exception {
        EasyMock.expect((Object)this.config.getTimeoutNanos(this.get)).andReturn((Object)Optional.of((Object)250000000L));
        InvokeHttpMethod invokeHttpMethod = this.invokeHttpMethod;
        invokeHttpMethod.getClass();
        InvokeHttpMethod.InvokeAndTransform invoke = new InvokeHttpMethod.InvokeAndTransform(invokeHttpMethod, "ns:get", this.getCommand);
        EasyMock.expect((Object)this.timeLimiter.callWithTimeout((Callable)invoke, 250000000L, TimeUnit.NANOSECONDS, true)).andReturn((Object)this.response);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        this.invokeHttpMethod.apply(this.get);
    }

    public void testMethodWithNoTimeoutCallGetDirectly() throws Exception {
        EasyMock.expect((Object)this.config.getTimeoutNanos(this.get)).andReturn((Object)Optional.absent());
        EasyMock.expect((Object)this.http.invoke(new HttpCommand(this.getRequest))).andReturn((Object)this.response);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        this.invokeHttpMethod.apply(this.get);
    }

    public void testDirectCallRunsFallbackCreateOrPropagate() throws Exception {
        IllegalStateException exception = new IllegalStateException();
        EasyMock.expect((Object)this.config.getTimeoutNanos(this.get)).andReturn((Object)Optional.absent());
        EasyMock.expect((Object)this.http.invoke(new HttpCommand(this.getRequest))).andThrow((Throwable)exception);
        EasyMock.expect((Object)this.fallback.createOrPropagate((Throwable)exception)).andReturn((Object)this.fallbackResponse);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        Assert.assertEquals((Object)this.invokeHttpMethod.apply(this.get), (Object)this.fallbackResponse);
    }

    public void testTimeLimitedRunsFallbackCreateOrPropagate() throws Exception {
        IllegalStateException exception = new IllegalStateException();
        EasyMock.expect((Object)this.config.getTimeoutNanos(this.get)).andReturn((Object)Optional.of((Object)250000000L));
        InvokeHttpMethod invokeHttpMethod = this.invokeHttpMethod;
        invokeHttpMethod.getClass();
        InvokeHttpMethod.InvokeAndTransform invoke = new InvokeHttpMethod.InvokeAndTransform(invokeHttpMethod, "ns:get", this.getCommand);
        EasyMock.expect((Object)this.timeLimiter.callWithTimeout((Callable)invoke, 250000000L, TimeUnit.NANOSECONDS, true)).andThrow((Throwable)exception);
        EasyMock.expect((Object)this.fallback.createOrPropagate((Throwable)exception)).andReturn((Object)this.fallbackResponse);
        EasyMock.replay((Object[])new Object[]{this.http, this.timeLimiter, this.fallback, this.config, this.future});
        Assert.assertEquals((Object)this.invokeHttpMethod.apply(this.get), (Object)this.fallbackResponse);
    }

    public static interface ThingApi {
        @Named(value="ns:get")
        public HttpResponse get();
    }
}

