/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InitScriptTest {
    InitScript testInitScript = InitScript.builder().name("mkebsboot").home("/mnt/tmp").exportVariables((Map)ImmutableMap.of((Object)"tmpDir", (Object)"/mnt/tmp")).run(new Statement[]{Statements.appendFile((String)"{tmp}{fs}{uid}{fs}scripttest{fs}temp.txt", (Iterable)ImmutableList.of((Object)"hello world")), Statements.exec((String)"find /")}).build();
    InitScript testCallInRun = InitScript.builder().name("testcall").init(Statements.exec((String)"echo hello")).run(new Statement[]{Statements.call((String)"sourceEnvFile", (String[])new String[]{"foo"}), Statements.exec((String)"find /")}).build();

    public void testBuildSimpleWindows() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.testInitScript.render(OsFamily.WINDOWS), (String)Resources.toString((URL)Resources.getResource((String)("test_init." + ShellToken.SH.to(OsFamily.WINDOWS))), (Charset)Charsets.UTF_8));
    }

    public void testBuildSimpleUNIX() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.testInitScript.render(OsFamily.UNIX), (String)Resources.toString((URL)Resources.getResource((String)("test_init." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8));
    }

    public void testBuildEBS() throws MalformedURLException, IOException {
        Assert.assertEquals((String)InitScript.builder().name("mkebsboot").home("tmp").logDir("/tmp/logs").exportVariables((Map)ImmutableMap.of((Object)"imageDir", (Object)"/mnt/tmp", (Object)"ebsDevice", (Object)"/dev/sdh", (Object)"ebsMountPoint", (Object)"/mnt/ebs")).run(Statements.interpret((String[])new String[]{"echo creating a filesystem and mounting the ebs volume", "{md} {varl}IMAGE_DIR{varr} {varl}EBS_MOUNT_POINT{varr}", "rm -rf {varl}IMAGE_DIR{varr}/*", "yes| mkfs -t ext3 {varl}EBS_DEVICE{varr} 2>&-", "mount {varl}EBS_DEVICE{varr} {varl}EBS_MOUNT_POINT{varr}", "echo making a local working copy of the boot disk", "rsync -ax --exclude /ubuntu/.bash_history --exclude /home/*/.bash_history --exclude /etc/ssh/ssh_host_* --exclude /etc/ssh/moduli --exclude /etc/udev/rules.d/*persistent-net.rules --exclude /var/lib/ec2/* --exclude=/mnt/* --exclude=/proc/* --exclude=/tmp/* --exclude=/dev/log / {varl}IMAGE_DIR{varr}", "echo preparing the local working copy", "touch {varl}IMAGE_DIR{varr}/etc/init.d/ec2-init-user-data", "echo copying the local working copy to the ebs mount", "{cd} {varl}IMAGE_DIR{varr}", "tar -cSf - * | tar xf - -C {varl}EBS_MOUNT_POINT{varr}", "echo size of ebs", "du -sk {varl}EBS_MOUNT_POINT{varr}", "echo size of source", "du -sk {varl}IMAGE_DIR{varr}", "rm -rf {varl}IMAGE_DIR{varr}/*", "umount {varl}EBS_MOUNT_POINT{varr}", "echo ----COMPLETE----"})).build().render(OsFamily.UNIX), (String)Resources.toString((URL)Resources.getResource((String)("test_ebs." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8));
    }

    @Test
    public void testCallInRunUNIX() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.testCallInRun.render(OsFamily.UNIX), (String)Resources.toString((URL)Resources.getResource((String)("test_init_script." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8));
    }
}

