/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.PipeHttpResponseTo;
import org.jclouds.scriptbuilder.domain.PipeHttpResponseToBash;
import org.jclouds.scriptbuilder.domain.PipeHttpResponseToTarxpzfIntoDirectory;
import org.jclouds.scriptbuilder.domain.Statements;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PipeHttpResponseToTest {
    PipeHttpResponseTo bash = new PipeHttpResponseTo(Statements.interpret((String[])new String[]{"bash"}), "GET", URI.create("https://adriancolehappy.s3.amazonaws.com/java/install"), (Multimap)ImmutableMultimap.of((Object)"Host", (Object)"adriancolehappy.s3.amazonaws.com", (Object)"Date", (Object)"Sun, 12 Sep 2010 08:25:19 GMT", (Object)"Authorization", (Object)"AWS 0ASHDJAS82:JASHFDA="));
    PipeHttpResponseToBash bash2 = new PipeHttpResponseToBash("GET", URI.create("https://adriancolehappy.s3.amazonaws.com/java/install"), (Multimap)ImmutableMultimap.of((Object)"Host", (Object)"adriancolehappy.s3.amazonaws.com", (Object)"Date", (Object)"Sun, 12 Sep 2010 08:25:19 GMT", (Object)"Authorization", (Object)"AWS 0ASHDJAS82:JASHFDA="));
    PipeHttpResponseTo untar = new PipeHttpResponseTo(Statements.interpret((String[])new String[]{"{md} {root}stage{fs} &&{cd} {root}stage{fs} &&tar -xpzf -"}), "GET", URI.create("https://adriancolehappy.s3.amazonaws.com/java/install"), (Multimap)ImmutableMultimap.of((Object)"Host", (Object)"adriancolehappy.s3.amazonaws.com", (Object)"Date", (Object)"Sun, 12 Sep 2010 08:25:19 GMT", (Object)"Authorization", (Object)"AWS 0ASHDJAS82:JASHFDA="));
    PipeHttpResponseTo untar2 = new PipeHttpResponseToTarxpzfIntoDirectory("GET", URI.create("https://adriancolehappy.s3.amazonaws.com/java/install"), (Multimap)ImmutableMultimap.of((Object)"Host", (Object)"adriancolehappy.s3.amazonaws.com", (Object)"Date", (Object)"Sun, 12 Sep 2010 08:25:19 GMT", (Object)"Authorization", (Object)"AWS 0ASHDJAS82:JASHFDA="), "{root}stage{fs}");

    public void testPipeHttpResponseToBashUNIX() {
        Assert.assertEquals((String)this.bash.render(OsFamily.UNIX), (String)"curl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20 -X GET -H \"Host: adriancolehappy.s3.amazonaws.com\" -H \"Date: Sun, 12 Sep 2010 08:25:19 GMT\" -H \"Authorization: AWS 0ASHDJAS82:JASHFDA=\" https://adriancolehappy.s3.amazonaws.com/java/install |(bash)\n");
        Assert.assertEquals((String)this.bash2.render(OsFamily.UNIX), (String)this.bash.render(OsFamily.UNIX));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testPipeHttpResponseToBashWINDOWS() {
        this.bash.render(OsFamily.WINDOWS);
    }

    public void testPipeHttpResponseToUntarUNIX() {
        Assert.assertEquals((String)this.untar.render(OsFamily.UNIX), (String)"curl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20 -X GET -H \"Host: adriancolehappy.s3.amazonaws.com\" -H \"Date: Sun, 12 Sep 2010 08:25:19 GMT\" -H \"Authorization: AWS 0ASHDJAS82:JASHFDA=\" https://adriancolehappy.s3.amazonaws.com/java/install |(mkdir -p /stage/ &&cd /stage/ &&tar -xpzf -)\n");
        Assert.assertEquals((String)this.untar.render(OsFamily.UNIX), (String)this.untar2.render(OsFamily.UNIX));
    }
}

