/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.functions;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class InitAdminAccessTest {
    public void testWhenNotAdminAccess() {
        AdminAccess.Configuration configuration = (AdminAccess.Configuration)EasyMock.createMock(AdminAccess.Configuration.class);
        InitAdminAccess initAdminAccess = new InitAdminAccess(configuration);
        EasyMock.replay((Object[])new Object[]{configuration});
        initAdminAccess.visit(Statements.exec((String)"echo hello"));
        initAdminAccess.visit(Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)"echo hello")}));
        EasyMock.verify((Object[])new Object[]{configuration});
    }

    public void testWhenAdminAccess() {
        AdminAccess.Configuration configuration = (AdminAccess.Configuration)EasyMock.createMock(AdminAccess.Configuration.class);
        AdminAccess statement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        AdminAccess newStatement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        EasyMock.expect((Object)statement.init(configuration)).andReturn((Object)newStatement);
        EasyMock.replay((Object[])new Object[]{configuration});
        EasyMock.replay((Object[])new Object[]{statement});
        EasyMock.replay((Object[])new Object[]{newStatement});
        InitAdminAccess initAdminAccess = new InitAdminAccess(configuration);
        initAdminAccess.visit(statement);
        EasyMock.verify((Object[])new Object[]{configuration});
        EasyMock.verify((Object[])new Object[]{statement});
        EasyMock.verify((Object[])new Object[]{newStatement});
    }

    public void testWhenAdminAccessInsideList() {
        AdminAccess.Configuration configuration = (AdminAccess.Configuration)EasyMock.createMock(AdminAccess.Configuration.class);
        AdminAccess statement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        AdminAccess newStatement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        EasyMock.expect((Object)statement.init(configuration)).andReturn((Object)newStatement);
        EasyMock.replay((Object[])new Object[]{configuration});
        EasyMock.replay((Object[])new Object[]{statement});
        EasyMock.replay((Object[])new Object[]{newStatement});
        InitAdminAccess initAdminAccess = new InitAdminAccess(configuration);
        initAdminAccess.visit(Statements.newStatementList((Statement[])new Statement[]{statement}));
        EasyMock.verify((Object[])new Object[]{configuration});
        EasyMock.verify((Object[])new Object[]{statement});
        EasyMock.verify((Object[])new Object[]{newStatement});
    }

    public void testWhenAdminAccessInsideInitBuilder() {
        AdminAccess.Configuration configuration = (AdminAccess.Configuration)EasyMock.createMock(AdminAccess.Configuration.class);
        AdminAccess statement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        AdminAccess newStatement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        EasyMock.expect((Object)statement.init(configuration)).andReturn((Object)newStatement);
        EasyMock.replay((Object[])new Object[]{configuration});
        EasyMock.replay((Object[])new Object[]{statement});
        EasyMock.replay((Object[])new Object[]{newStatement});
        InitScript testInitBuilder = InitScript.builder().name("mkebsboot").home("/mnt/tmp").exportVariables((Map)ImmutableMap.of((Object)"tmpDir", (Object)"/mnt/tmp")).run((Statement)statement).build();
        InitAdminAccess initAdminAccess = new InitAdminAccess(configuration);
        initAdminAccess.visit((Statement)testInitBuilder);
        EasyMock.verify((Object[])new Object[]{configuration});
        EasyMock.verify((Object[])new Object[]{statement});
        EasyMock.verify((Object[])new Object[]{newStatement});
    }
}

