/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.base.Function;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.statements.login.ReplaceShadowPasswordEntryOfLoginUser;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ReplaceShadowPasswordEntryOfLoginUserTest {
    Function<String, String> crypt = new Function<String, String>(){

        public String apply(String in) {
            Assert.assertEquals((String)in, (String)"password");
            return "CRYPT";
        }
    };

    public void testWithPasswordUNIX() {
        String cmd = new ReplaceShadowPasswordEntryOfLoginUser(this.crypt, "password").render(OsFamily.UNIX);
        assert (cmd.startsWith("awk -v user=^${SUDO_USER:=${USER}}: -v password='CRYPT")) : cmd;
        assert (cmd.endsWith("' 'BEGIN { FS=OFS=\":\" } $0 ~ user { $2 = password } 1' /etc/shadow >/etc/shadow.${SUDO_USER:=${USER}}\ntest -f /etc/shadow.${SUDO_USER:=${USER}} && mv /etc/shadow.${SUDO_USER:=${USER}} /etc/shadow\n")) : cmd;
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAddUserWindowsNotSupported() {
        new ReplaceShadowPasswordEntryOfLoginUser(this.crypt, "password").render(OsFamily.WINDOWS);
    }
}

