/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

public enum TestConfiguration implements AdminAccess.Configuration
{
    INSTANCE;

    int pwCount = 0;
    private final Supplier<String> defaultAdminUsername = Suppliers.ofInstance((Object)"defaultAdminUsername");
    private final Supplier<Map<String, String>> defaultAdminSshKeys = Suppliers.ofInstance((Object)ImmutableMap.of((Object)"public", (Object)"publicKey", (Object)"private", (Object)"privateKey"));
    private final Supplier<String> passwordGenerator = new Supplier<String>(){

        public String get() {
            return TestConfiguration.this.pwCount++ + "";
        }
    };
    private final Function<String, String> cryptFunction = new Function<String, String>(){

        public String apply(String input) {
            return String.format("crypt(%s)", input);
        }
    };

    public TestConfiguration reset() {
        this.pwCount = 0;
        return this;
    }

    public Supplier<String> defaultAdminUsername() {
        return this.defaultAdminUsername;
    }

    public Supplier<Map<String, String>> defaultAdminSshKeys() {
        return this.defaultAdminSshKeys;
    }

    public Supplier<String> passwordGenerator() {
        return this.passwordGenerator;
    }

    public Function<String, String> cryptFunction() {
        return this.cryptFunction;
    }
}

