/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.compute.internal.BaseAWSEC2ComputeServiceExpectTest;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSEC2ComputeServiceExpectTest")
public class AWSEC2ComputeServiceExpectTest
extends BaseAWSEC2ComputeServiceExpectTest {
    private HttpResponse requestSpotInstancesResponse;
    private HttpRequest describeSpotInstanceRequest;
    private HttpResponse describeSpotInstanceResponse;
    String iamInstanceProfileArn = "arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver";

    @Override
    @BeforeClass
    protected void setupDefaultRequests() {
        super.setupDefaultRequests();
        this.requestSpotInstancesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/request_spot_instances-ebs.xml", "application/xml"))).build();
        this.describeSpotInstanceRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSpotInstanceRequests"}).addFormParam("SpotInstanceRequestId.1", new String[]{"sir-228e6406"}).build());
        this.describeSpotInstanceResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/request_spot_instances-ebs.xml", "application/xml"))).build();
    }

    public void testLaunchVPCSpotInstanceSubnetId() throws Exception {
        HttpRequest requestSpotInstancesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"RequestSpotInstances"}).addFormParam("InstanceCount", new String[]{"1"}).addFormParam("LaunchSpecification.ImageId", new String[]{"ami-be3adfd7"}).addFormParam("LaunchSpecification.InstanceType", new String[]{"m1.small"}).addFormParam("LaunchSpecification.KeyName", new String[]{"Demo"}).addFormParam("LaunchSpecification.Placement.AvailabilityZone", new String[]{"us-east-1a"}).addFormParam("LaunchSpecification.SubnetId", new String[]{"subnet-xyz"}).addFormParam("LaunchSpecification.UserData", new String[]{"I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK"}).addFormParam("SpotPrice", new String[]{"1.0"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)requestSpotInstancesRequest, (Object)this.requestSpotInstancesResponse);
        requestResponseMap.put((Object)this.describeSpotInstanceRequest, (Object)this.describeSpotInstanceResponse);
        ComputeService createsVPCSpotInstance = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        Template template = createsVPCSpotInstance.templateBuilder().locationId("us-east-1a").build();
        ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).spotPrice(Float.valueOf(1.0f)).subnetId("subnet-xyz").keyPair("Demo").blockUntilRunning(false);
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)createsVPCSpotInstance.createNodesInGroup("test", 1, template));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/sir-228e6406");
    }

    public void testLaunchSpotInstanceIAMInstanceProfileArn() throws Exception {
        HttpRequest requestSpotInstancesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"RequestSpotInstances"}).addFormParam("InstanceCount", new String[]{"1"}).addFormParam("LaunchSpecification.IamInstanceProfile.Arn", new String[]{this.iamInstanceProfileArn}).addFormParam("LaunchSpecification.ImageId", new String[]{"ami-be3adfd7"}).addFormParam("LaunchSpecification.InstanceType", new String[]{"m1.small"}).addFormParam("LaunchSpecification.Placement.AvailabilityZone", new String[]{"us-east-1a"}).addFormParam("LaunchSpecification.SecurityGroup.1", new String[]{"jclouds#test"}).addFormParam("LaunchSpecification.UserData", new String[]{"I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK"}).addFormParam("SpotPrice", new String[]{"1.0"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)requestSpotInstancesRequest, (Object)this.requestSpotInstancesResponse);
        requestResponseMap.put((Object)this.describeSpotInstanceRequest, (Object)this.describeSpotInstanceResponse);
        ComputeService createsSpotInstance = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        Template template = createsSpotInstance.templateBuilder().locationId("us-east-1a").build();
        ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).spotPrice(Float.valueOf(1.0f)).iamInstanceProfileArn(this.iamInstanceProfileArn).noKeyPair().blockUntilRunning(false);
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)createsSpotInstance.createNodesInGroup("test", 1, template));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/sir-228e6406");
    }

    public void testLaunchSpotInstanceIAMInstanceProfileName() throws Exception {
        HttpRequest requestSpotInstancesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"RequestSpotInstances"}).addFormParam("InstanceCount", new String[]{"1"}).addFormParam("LaunchSpecification.IamInstanceProfile.Name", new String[]{"Webserver"}).addFormParam("LaunchSpecification.ImageId", new String[]{"ami-be3adfd7"}).addFormParam("LaunchSpecification.InstanceType", new String[]{"m1.small"}).addFormParam("LaunchSpecification.Placement.AvailabilityZone", new String[]{"us-east-1a"}).addFormParam("LaunchSpecification.SecurityGroup.1", new String[]{"jclouds#test"}).addFormParam("LaunchSpecification.UserData", new String[]{"I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK"}).addFormParam("SpotPrice", new String[]{"1.0"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)requestSpotInstancesRequest, (Object)this.requestSpotInstancesResponse);
        requestResponseMap.put((Object)this.describeSpotInstanceRequest, (Object)this.describeSpotInstanceResponse);
        ComputeService createsSpotInstance = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        Template template = createsSpotInstance.templateBuilder().locationId("us-east-1a").build();
        ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).spotPrice(Float.valueOf(1.0f)).iamInstanceProfileName("Webserver").noKeyPair().blockUntilRunning(false);
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)createsSpotInstance.createNodesInGroup("test", 1, template));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/sir-228e6406");
    }

    public void testCreateNodeWithIAMInstanceProfileArn() throws Exception {
        HttpRequest runInstancesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"RunInstances"}).addFormParam("IamInstanceProfile.Arn", new String[]{this.iamInstanceProfileArn}).addFormParam("ImageId", new String[]{"ami-be3adfd7"}).addFormParam("InstanceType", new String[]{"m1.small"}).addFormParam("MaxCount", new String[]{"1"}).addFormParam("MinCount", new String[]{"1"}).addFormParam("SecurityGroup.1", new String[]{"jclouds#test"}).addFormParam("UserData", new String[]{"I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)runInstancesRequest, (Object)this.runInstancesResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)this.describeInstanceResponse);
        requestResponseMap.put((Object)this.describeImageRequest, (Object)this.describeImagesResponse);
        ComputeService apiThatCreatesNode = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)apiThatCreatesNode.createNodesInGroup("test", 1, (TemplateOptions)AWSEC2TemplateOptions.Builder.blockUntilRunning((boolean)false).iamInstanceProfileArn(this.iamInstanceProfileArn).noKeyPair()));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/i-2baa5550");
    }

    public void testCreateNodeWithIAMInstanceProfileName() throws Exception {
        HttpRequest runInstancesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"RunInstances"}).addFormParam("IamInstanceProfile.Name", new String[]{"Webserver"}).addFormParam("ImageId", new String[]{"ami-be3adfd7"}).addFormParam("InstanceType", new String[]{"m1.small"}).addFormParam("MaxCount", new String[]{"1"}).addFormParam("MinCount", new String[]{"1"}).addFormParam("SecurityGroup.1", new String[]{"jclouds#test"}).addFormParam("UserData", new String[]{"I2Nsb3VkLWNvbmZpZwpyZXBvX3VwZ3JhZGU6IG5vbmUK"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)runInstancesRequest, (Object)this.runInstancesResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)this.describeInstanceResponse);
        requestResponseMap.put((Object)this.describeImageRequest, (Object)this.describeImagesResponse);
        ComputeService apiThatCreatesNode = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)apiThatCreatesNode.createNodesInGroup("test", 1, (TemplateOptions)AWSEC2TemplateOptions.Builder.blockUntilRunning((boolean)false).iamInstanceProfileName("Webserver").noKeyPair()));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/i-2baa5550");
    }

    public void testListNodesWhereImageDoesntExist() throws Exception {
        HttpRequest describeInstancesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeInstances"}).build());
        HttpRequest describeSpotInstancesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSpotInstanceRequests"}).build());
        HttpResponse noSpotInstancesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(AWSEC2ComputeServiceExpectTest.payloadFromStringWithContentType((String)"<DescribeSpotInstanceRequestsResponse><spotInstanceRequestSet></spotInstanceRequestSet></DescribeSpotInstanceRequestsResponse>", (String)"application/xml"))).build();
        HttpResponse noImagesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(AWSEC2ComputeServiceExpectTest.payloadFromStringWithContentType((String)"<DescribeImagesResponse><imagesSet></imagesSet></DescribeImagesResponse>", (String)"application/xml"))).build();
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)noImagesResponse);
        requestResponseMap.put((Object)describeInstancesRequest, (Object)this.describeInstanceResponse);
        requestResponseMap.put((Object)describeSpotInstancesRequest, (Object)noSpotInstancesResponse);
        ComputeService listsWithoutImages = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)listsWithoutImages.listNodesDetailsMatching(NodePredicates.all()));
        Assert.assertEquals((String)node.getId(), (String)"us-east-1/i-2baa5550");
    }
}

