/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.cloudwatch.AWSCloudWatchProviderMetadata;
import org.jclouds.aws.ec2.AWSEC2ApiMetadata;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.options.CreateSecurityGroupOptions;
import org.jclouds.aws.ec2.services.AWSSecurityGroupClient;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.GetMetricStatistics;
import org.jclouds.cloudwatch.domain.GetMetricStatisticsResponse;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.EC2ComputeServiceLiveTest;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.services.InstanceClient;
import org.jclouds.ec2.services.KeyPairClient;
import org.jclouds.ec2.services.SecurityGroupClient;
import org.jclouds.ec2.util.IpPermissions;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.scriptbuilder.domain.Statements;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AWSEC2ComputeServiceLiveTest")
public class AWSEC2ComputeServiceLiveTest
extends EC2ComputeServiceLiveTest {
    public AWSEC2ComputeServiceLiveTest() {
        this.provider = "aws-ec2";
        this.group = "ec2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtendedOptionsAndLogin() throws Exception {
        String region = "us-west-2";
        AWSSecurityGroupClient securityGroupClient = ((AWSEC2Client)AWSEC2Client.class.cast(((RestContext)((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN)).getApi())).getSecurityGroupServices();
        KeyPairClient keyPairClient = ((EC2Client)EC2Client.class.cast(((RestContext)((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN)).getApi())).getKeyPairServices();
        InstanceClient instanceClient = ((EC2Client)EC2Client.class.cast(((RestContext)((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN)).getApi())).getInstanceServices();
        String group = this.group + "o";
        Date before = new Date();
        ImmutableMap userMetadata = ImmutableMap.of((Object)"test", (Object)group);
        ImmutableSet tags = ImmutableSet.of((Object)group);
        Template template = this.client.templateBuilder().locationId(region).osFamily(OsFamily.AMZN_LINUX).os64Bit(true).build();
        template.getOptions().tags((Iterable)tags);
        template.getOptions().userMetadata((Map)userMetadata);
        template.getOptions().tags((Iterable)tags);
        ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).enableMonitoring();
        ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).spotPrice(Float.valueOf(0.3f));
        String startedId = null;
        try {
            AWSEC2ComputeServiceLiveTest.cleanupExtendedStuffInRegion((String)region, (SecurityGroupClient)securityGroupClient, (KeyPairClient)keyPairClient, (String)group);
            Thread.sleep(3000L);
            String groupId = securityGroupClient.createSecurityGroupInRegionAndReturnId(region, group, group, new CreateSecurityGroupOptions[0]);
            securityGroupClient.authorizeSecurityGroupIngressInRegion(region, groupId, (IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(22));
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).securityGroupIds(new String[]{groupId});
            KeyPair result = keyPairClient.createKeyPairInRegion(region, group);
            ((AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class)).keyPair(result.getKeyName());
            assert (result.getKeyMaterial() != null) : result;
            template.getOptions().overrideLoginPrivateKey(result.getKeyMaterial());
            Set nodes = this.client.createNodesInGroup(group, 1, template);
            NodeMetadata first = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes);
            this.checkUserMetadataContains(first, userMetadata);
            this.checkTagsInNodeEquals(first, tags);
            assert (first.getCredentials() != null) : first;
            assert (first.getCredentials().identity != null) : first;
            startedId = first.getProviderId();
            AWSRunningInstance instance = (AWSRunningInstance)AWSRunningInstance.class.cast(Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)instanceClient.describeInstancesInRegion(region, new String[]{startedId})))));
            Assert.assertEquals((String)instance.getKeyName(), (String)group);
            assert (instance.getSpotInstanceRequestId() != null);
            Assert.assertEquals((Object)instance.getMonitoringState(), (Object)MonitoringState.ENABLED);
            ListenableFuture future = this.client.submitScriptOnNode(first.getId(), Statements.exec((String)"while true; do true; done"), RunScriptOptions.Builder.runAsRoot((boolean)false).nameTask("cpuSpinner"));
            Thread.sleep(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
            future.cancel(true);
            CloudWatchApi monitoringApi = (CloudWatchApi)ContextBuilder.newBuilder((ProviderMetadata)new AWSCloudWatchProviderMetadata()).credentials(this.identity, this.credential).modules(this.setupModules()).buildApi(CloudWatchApi.class);
            try {
                GetMetricStatisticsResponse datapoints = monitoringApi.getMetricApiForRegion(instance.getRegion()).getMetricStatistics(GetMetricStatistics.builder().dimension(new Dimension("InstanceId", instance.getId())).unit(Unit.PERCENT).namespace("AWS/EC2").metricName("CPUUtilization").startTime(before).endTime(new Date()).period(60).statistic(Statistics.AVERAGE).build());
                assert (datapoints.size() > 0) : instance;
            }
            finally {
                monitoringApi.close();
            }
            Assert.assertEquals((Set)Sets.newTreeSet((Iterable)instance.getGroupNames()), (Set)ImmutableSortedSet.of((Comparable)((Object)("jclouds#" + group)), (Comparable)((Object)group)));
            SecurityGroup secgroup = (SecurityGroup)Iterables.getOnlyElement((Iterable)securityGroupClient.describeSecurityGroupsInRegion(instance.getRegion(), new String[]{"jclouds#" + group}));
            assert (secgroup.size() == 0) : secgroup;
            this.runScriptWithCreds(group, first.getOperatingSystem(), LoginCredentials.builder().user(first.getCredentials().identity).privateKey(result.getKeyMaterial()).build());
        }
        catch (Throwable throwable) {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
            if (startedId != null) {
                Assert.assertEquals((int)keyPairClient.describeKeyPairsInRegion(region, new String[]{group}).size(), (int)1);
                Assert.assertEquals((int)securityGroupClient.describeSecurityGroupsInRegion(region, new String[]{group}).size(), (int)1);
            }
            AWSEC2ComputeServiceLiveTest.cleanupExtendedStuffInRegion((String)region, (SecurityGroupClient)securityGroupClient, (KeyPairClient)keyPairClient, (String)group);
            throw throwable;
        }
        this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        if (startedId != null) {
            Assert.assertEquals((int)keyPairClient.describeKeyPairsInRegion(region, new String[]{group}).size(), (int)1);
            Assert.assertEquals((int)securityGroupClient.describeSecurityGroupsInRegion(region, new String[]{group}).size(), (int)1);
        }
        AWSEC2ComputeServiceLiveTest.cleanupExtendedStuffInRegion((String)region, (SecurityGroupClient)securityGroupClient, (KeyPairClient)keyPairClient, (String)group);
    }
}

