/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.extensions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.extensions.internal.BaseImageExtensionLiveTest;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AWSEC2ImageExtensionLiveTest")
public class AWSEC2ImageExtensionLiveTest
extends BaseImageExtensionLiveTest {
    public AWSEC2ImageExtensionLiveTest() {
        this.provider = "aws-ec2";
    }

    protected Iterable<? extends Image> listImages() {
        AWSEC2Client client = (AWSEC2Client)((ComputeServiceContext)this.view).utils().injector().getInstance(AWSEC2Client.class);
        String[] parts = AWSUtils.parseHandle((String)this.imageId);
        String region = parts[0];
        String imageId = parts[1];
        EC2ImageParser parser = (EC2ImageParser)((ComputeServiceContext)this.view).utils().injector().getInstance(EC2ImageParser.class);
        return Iterables.transform((Iterable)client.getAMIServices().describeImagesInRegion(region, new DescribeImagesOptions[]{new DescribeImagesOptions().imageIds(new String[]{imageId})}), (Function)parser);
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

