/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.aws.ec2.AWSEC2ApiMetadata;
import org.jclouds.aws.ec2.compute.functions.AWSRunningInstanceToNodeMetadata;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.date.DateService;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.ImagesToRegionAndIdMap;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class AWSRunningInstanceToNodeMetadataTest {
    private static final String defaultRegion = "us-east-1";
    static Location provider = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").build();
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        this.dateService = (DateService)Guice.createInjector((Module[])new Module[0]).getInstance(DateService.class);
        assert (this.dateService != null);
    }

    @Test
    public void test2Nodes() {
        AWSRunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of(), (ImmutableSet<Location>)ImmutableSet.of(), (Set<Image>)ImmutableSet.of(), (Map<String, Credentials>)ImmutableMap.of());
        ImmutableSet contents = ImmutableSet.of((Object)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)new AWSRunningInstance.Builder().region(defaultRegion)).instanceId("i-911444f0")).imageId("ami-63be790a")).instanceState(InstanceState.RUNNING)).rawState("running")).privateDnsName("ip-10-212-81-7.ec2.internal")).dnsName("ec2-174-129-173-155.compute-1.amazonaws.com")).keyName("jclouds#zkclustertest#23")).amiLaunchIndex("0")).instanceType("t1.micro")).launchTime(this.dateService.iso8601DateParse("2011-08-16T13:40:50.000Z"))).availabilityZone("us-east-1c")).kernelId("aki-427d952b")).monitoringState(MonitoringState.DISABLED).privateIpAddress("10.212.81.7")).ipAddress("174.129.173.155")).securityGroupIdToNames((Map)ImmutableMap.of((Object)"sg-ef052b86", (Object)"jclouds#zkclustertest")).rootDeviceType(RootDeviceType.EBS)).rootDeviceName("/dev/sda1")).device("/dev/sda1", new BlockDevice("vol-5829fc32", Attachment.Status.ATTACHED, this.dateService.iso8601DateParse("2011-08-16T13:41:19.000Z"), true))).virtualizationType("paravirtual")).tag("Name", "foo")).tag("Empty", "")).hypervisor(Hypervisor.XEN).build(), (Object)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)new AWSRunningInstance.Builder().region(defaultRegion)).instanceId("i-931444f2")).imageId("ami-63be790a")).instanceState(InstanceState.RUNNING)).rawState("running")).privateDnsName("ip-10-212-185-8.ec2.internal")).dnsName("ec2-50-19-207-248.compute-1.amazonaws.com")).keyName("jclouds#zkclustertest#23")).amiLaunchIndex("0")).instanceType("t1.micro")).launchTime(this.dateService.iso8601DateParse("2011-08-16T13:40:50.000Z"))).availabilityZone("us-east-1c")).kernelId("aki-427d952b")).monitoringState(MonitoringState.DISABLED).privateIpAddress("10.212.185.8")).ipAddress("50.19.207.248")).securityGroupIdToNames((Map)ImmutableMap.of((Object)"sg-ef052b86", (Object)"jclouds#zkclustertest")).rootDeviceType(RootDeviceType.EBS)).rootDeviceName("/dev/sda1")).device("/dev/sda1", new BlockDevice("vol-5029fc3a", Attachment.Status.ATTACHED, this.dateService.iso8601DateParse("2011-08-16T13:41:19.000Z"), true))).virtualizationType("paravirtual")).hypervisor(Hypervisor.XEN).build());
        Assert.assertEquals((String)parser.apply((RunningInstance)Iterables.get((Iterable)contents, (int)0)).toString(), (String)new NodeMetadataBuilder().status(NodeMetadata.Status.RUNNING).backendStatus("running").group("zkclustertest").name("foo").hostname("ip-10-212-81-7").privateAddresses((Iterable)ImmutableSet.of((Object)"10.212.81.7")).publicAddresses((Iterable)ImmutableSet.of((Object)"174.129.173.155")).imageId("us-east-1/ami-63be790a").id("us-east-1/i-911444f0").providerId("i-911444f0").tags((Iterable)ImmutableSet.of((Object)"Empty")).userMetadata((Map)ImmutableMap.of((Object)"Name", (Object)"foo")).build().toString());
        Assert.assertEquals((String)parser.apply((RunningInstance)Iterables.get((Iterable)contents, (int)1)).toString(), (String)new NodeMetadataBuilder().status(NodeMetadata.Status.RUNNING).backendStatus("running").group("zkclustertest").hostname("ip-10-212-185-8").privateAddresses((Iterable)ImmutableSet.of((Object)"10.212.185.8")).publicAddresses((Iterable)ImmutableSet.of((Object)"50.19.207.248")).imageId("us-east-1/ami-63be790a").id("us-east-1/i-931444f2").providerId("i-931444f2").build().toString());
    }

    protected AWSRunningInstanceToNodeMetadata createNodeParser(ImmutableSet<Hardware> hardware, ImmutableSet<Location> locations, Set<Image> images, Map<String, Credentials> credentialStore) {
        Map instanceToNodeStatus = EC2ComputeServiceDependenciesModule.toPortableNodeStatus;
        final Map backing = ImagesToRegionAndIdMap.imagesToMap(images);
        LoadingCache instanceToImage = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<RegionAndName, Image>(){

            public Image load(RegionAndName key) throws Exception {
                return (Image)backing.get(key);
            }
        });
        return this.createNodeParser(hardware, locations, credentialStore, instanceToNodeStatus, (LoadingCache<RegionAndName, ? extends Image>)instanceToImage);
    }

    private AWSRunningInstanceToNodeMetadata createNodeParser(final ImmutableSet<Hardware> hardware, final ImmutableSet<Location> locations, Map<String, Credentials> credentialStore, Map<InstanceState, NodeMetadata.Status> instanceToNodeStatus, LoadingCache<RegionAndName, ? extends Image> instanceToImage) {
        Supplier<Set<? extends Location>> locationSupplier = new Supplier<Set<? extends Location>>(){

            public Set<? extends Location> get() {
                return locations;
            }
        };
        Supplier<Set<? extends Hardware>> hardwareSupplier = new Supplier<Set<? extends Hardware>>(){

            public Set<? extends Hardware> get() {
                return hardware;
            }
        };
        GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)new AWSEC2ApiMetadata().getDefaultProperties());
            }
        }}).getInstance(GroupNamingConvention.Factory.class);
        AWSRunningInstanceToNodeMetadata parser = new AWSRunningInstanceToNodeMetadata(instanceToNodeStatus, credentialStore, Suppliers.ofInstance(instanceToImage), (Supplier)locationSupplier, (Supplier)hardwareSupplier, namingConvention);
        return parser;
    }
}

