/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.internal;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.aws.ec2.config.AWSEC2RestClientModule;
import org.jclouds.date.DateService;
import org.jclouds.ec2.compute.internal.BaseEC2ComputeServiceExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.ConfiguresRestClient;
import org.testng.annotations.BeforeClass;

public abstract class BaseAWSEC2ComputeServiceExpectTest
extends BaseEC2ComputeServiceExpectTest {
    public BaseAWSEC2ComputeServiceExpectTest() {
        this.provider = "aws-ec2";
    }

    protected Properties setupProperties() {
        Properties properties = super.setupProperties();
        properties.setProperty("jclouds.ec2.cc-ami-query", "");
        properties.setProperty("jclouds.ec2.generate-instance-names", "false");
        return properties;
    }

    @BeforeClass
    protected void setupDefaultRequests() {
        super.setupDefaultRequests();
        this.authorizeSecurityGroupIngressRequest22 = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"AuthorizeSecurityGroupIngress"}).addFormParam("GroupId", new String[]{"sg-3c6ef654"}).addFormParam("IpPermissions.0.FromPort", new String[]{"22"}).addFormParam("IpPermissions.0.ToPort", new String[]{"22"}).addFormParam("IpPermissions.0.IpRanges.0.CidrIp", new String[]{"0.0.0.0/0"}).addFormParam("IpPermissions.0.IpProtocol", new String[]{"tcp"}).addFormParam("IpPermissions.1.FromPort", new String[]{"0"}).addFormParam("IpPermissions.1.ToPort", new String[]{"65535"}).addFormParam("IpPermissions.1.Groups.0.GroupName", new String[]{"jclouds#test"}).addFormParam("IpPermissions.1.Groups.0.UserId", new String[]{"993194456877"}).addFormParam("IpPermissions.1.IpProtocol", new String[]{"tcp"}).addFormParam("IpPermissions.2.FromPort", new String[]{"0"}).addFormParam("IpPermissions.2.ToPort", new String[]{"65535"}).addFormParam("IpPermissions.2.Groups.0.GroupName", new String[]{"jclouds#test"}).addFormParam("IpPermissions.2.Groups.0.UserId", new String[]{"993194456877"}).addFormParam("IpPermissions.2.IpProtocol", new String[]{"udp"}).build());
        this.describeImagesRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeImages"}).addFormParam("Filter.1.Name", new String[]{"owner-id"}).addFormParam("Filter.1.Value.1", new String[]{"137112412989"}).addFormParam("Filter.1.Value.2", new String[]{"801119661308"}).addFormParam("Filter.1.Value.3", new String[]{"063491364108"}).addFormParam("Filter.1.Value.4", new String[]{"099720109477"}).addFormParam("Filter.1.Value.5", new String[]{"411009282317"}).addFormParam("Filter.2.Name", new String[]{"state"}).addFormParam("Filter.2.Value.1", new String[]{"available"}).addFormParam("Filter.3.Name", new String[]{"image-type"}).addFormParam("Filter.3.Value.1", new String[]{"machine"}).build());
    }

    protected Module createModule() {
        return new TestAWSEC2RestClientModule();
    }

    @ConfiguresRestClient
    protected static class TestAWSEC2RestClientModule
    extends AWSEC2RestClientModule {
        protected TestAWSEC2RestClientModule() {
        }

        protected void configure() {
            super.configure();
            final AtomicInteger suffix = new AtomicInteger();
            this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)new Supplier<String>(){

                public String get() {
                    return suffix.getAndIncrement() + "";
                }
            });
        }

        @Provides
        protected String provideTimeStamp(DateService dateService) {
            return "2012-04-16T15:54:08.897Z";
        }
    }
}

