/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.loaders;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.jclouds.aws.ec2.compute.loaders.AWSEC2CreateSecurityGroupIfNeeded;
import org.jclouds.aws.ec2.services.AWSSecurityGroupClient;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.SecurityGroup;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="AWSEC2CreateSecurityGroupIfNeeded")
public class AWSEC2CreateSecurityGroupIfNeededTest {
    @Test
    public void testWhenPort22AndToItselfAuthorizesIngressOnce() throws ExecutionException {
        AWSSecurityGroupClient client = (AWSSecurityGroupClient)EasyMock.createMock(AWSSecurityGroupClient.class);
        Predicate tester = Predicates.alwaysTrue();
        SecurityGroup group = (SecurityGroup)EasyMock.createNiceMock(SecurityGroup.class);
        ImmutableSet groups = ImmutableSet.of((Object)group);
        ImmutableSet.Builder permissions = ImmutableSet.builder();
        permissions.add((Object)IpPermission.builder().fromPort(22).toPort(22).ipProtocol(IpProtocol.TCP).ipRange("0.0.0.0/0").build());
        permissions.add((Object)IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.TCP).userIdGroupPair("ownerId", "group").build());
        permissions.add((Object)IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.UDP).userIdGroupPair("ownerId", "group").build());
        client.createSecurityGroupInRegion("region", "group", "group");
        EasyMock.expect((Object)group.getOwnerId()).andReturn((Object)"ownerId");
        EasyMock.expect((Object)group.getId()).andReturn((Object)"sg-123456");
        EasyMock.expect((Object)client.describeSecurityGroupsInRegion("region", new String[]{"group"})).andReturn(Set.class.cast(groups));
        client.authorizeSecurityGroupIngressInRegion("region", "sg-123456", (Iterable)permissions.build());
        EasyMock.expect((Object)client.describeSecurityGroupsInRegion("region", new String[]{"group"})).andReturn(Set.class.cast(groups));
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{group});
        AWSEC2CreateSecurityGroupIfNeeded function = new AWSEC2CreateSecurityGroupIfNeeded(client, tester);
        Assert.assertEquals((String)"group", (String)function.load((RegionAndName)new RegionNameAndIngressRules("region", "group", new int[]{22}, true)));
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{group});
    }
}

