/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.options;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AWSEC2TemplateOptionsTest {
    public void testAs() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((Object)options.as(AWSEC2TemplateOptions.class), (Object)options);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="all security groups must be non-empty")
    public void testsecurityGroupIdsIterableBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroupIds((Iterable)ImmutableSet.of((Object)"groupId1", (Object)""));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testsecurityGroupIdsIterableEmptyNotOk() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroupIds((Iterable)ImmutableSet.of());
    }

    @Test
    public void testsecurityGroupIdsIterable() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroupIds((Iterable)ImmutableSet.of((Object)"groupId1", (Object)"groupId2"));
        Assert.assertEquals((Set)options.getGroupIds(), (Set)ImmutableSet.of((Object)"groupId1", (Object)"groupId2"));
    }

    @Test
    public void testsecurityGroupIdsIterableStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.securityGroupIds((Iterable)ImmutableSet.of((Object)"groupId1", (Object)"groupId2"));
        Assert.assertEquals((Set)options.getGroupIds(), (Set)ImmutableSet.of((Object)"groupId1", (Object)"groupId2"));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="all security groups must be non-empty")
    public void testsecurityGroupIdsVarArgsBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroupIds(new String[]{"mygroupId", ""});
    }

    @Test
    public void testsecurityGroupIdsVarArgs() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroupIds(new String[]{"groupId1", "groupId2"});
        Assert.assertEquals((Set)options.getGroupIds(), (Set)ImmutableSet.of((Object)"groupId1", (Object)"groupId2"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testsecurityGroupIdsVarArgsEmptyNotOk() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroupIds(new String[0]);
    }

    @Test
    public void testDefaultGroupIdsVarArgsEmpty() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((Set)options.getGroupIds(), (Set)ImmutableSet.of());
    }

    @Test
    public void testsecurityGroupIdsVarArgsStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.securityGroupIds((String[])new String[]{"groupId1", "groupId2"});
        Assert.assertEquals((Set)options.getGroupIds(), (Set)ImmutableSet.of((Object)"groupId1", (Object)"groupId2"));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="all security groups must be non-empty")
    public void testsecurityGroupsIterableBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroups((Iterable)ImmutableSet.of((Object)"group1", (Object)""));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testsecurityGroupsIterableEmptyNotOk() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroups((Iterable)ImmutableSet.of());
    }

    @Test
    public void testsecurityGroupsIterable() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroups((Iterable)ImmutableSet.of((Object)"group1", (Object)"group2"));
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of((Object)"group1", (Object)"group2"));
    }

    @Test
    public void testsecurityGroupsIterableStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.securityGroups((Iterable)ImmutableSet.of((Object)"group1", (Object)"group2"));
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of((Object)"group1", (Object)"group2"));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="all security groups must be non-empty")
    public void testsecurityGroupsVarArgsBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroups(new String[]{"mygroup", ""});
    }

    @Test
    public void testsecurityGroupsVarArgs() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroups(new String[]{"group1", "group2"});
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of((Object)"group1", (Object)"group2"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testsecurityGroupsVarArgsEmptyNotOk() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.securityGroups(new String[0]);
    }

    @Test
    public void testDefaultGroupsVarArgsEmpty() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of());
    }

    @Test
    public void testsecurityGroupsVarArgsStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.securityGroups((String[])new String[]{"group1", "group2"});
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of((Object)"group1", (Object)"group2"));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="use noKeyPair option to request boot without a keypair")
    public void testkeyPairBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.keyPair("");
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testkeyPairAndNoKeyPair() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.keyPair("mykeypair");
        options.noKeyPair();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testNoKeyPairAndKeyPair() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.noKeyPair();
        options.keyPair("mykeypair");
    }

    @Test
    public void testkeyPair() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.keyPair("mykeypair");
        Assert.assertEquals((String)options.getKeyPair(), (String)"mykeypair");
    }

    @Test
    public void testNullkeyPair() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((String)options.getKeyPair(), null);
    }

    @Test
    public void testkeyPairStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.keyPair((String)"mykeypair");
        Assert.assertEquals((String)options.getKeyPair(), (String)"mykeypair");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testkeyPairNPE() {
        AWSEC2TemplateOptions.Builder.keyPair(null);
    }

    @Test
    public void testnoKeyPair() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.noKeyPair();
        Assert.assertEquals((String)options.getKeyPair(), null);
        assert (!options.shouldAutomaticallyCreateKeyPair());
    }

    @Test
    public void testFalsenoKeyPair() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((String)options.getKeyPair(), null);
        assert (options.shouldAutomaticallyCreateKeyPair());
    }

    @Test
    public void testnoKeyPairStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.noKeyPair();
        Assert.assertEquals((String)options.getKeyPair(), null);
        assert (!options.shouldAutomaticallyCreateKeyPair());
    }

    @Test
    public void testMonitoringEnabledDefault() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        assert (!options.isMonitoringEnabled());
    }

    @Test
    public void testMonitoringEnabled() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.enableMonitoring();
        assert (options.isMonitoringEnabled());
    }

    @Test
    public void testEnableMonitoringStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.enableMonitoring();
        Assert.assertEquals((String)options.getKeyPair(), null);
        assert (options.isMonitoringEnabled());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinstallPrivateKeyBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.installPrivateKey("whompy");
    }

    @Test
    public void testinstallPrivateKey() throws IOException {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.installPrivateKey("-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test
    public void testNullinstallPrivateKey() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((String)options.getPrivateKey(), null);
    }

    @Test
    public void testinstallPrivateKeyStatic() throws IOException {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.installPrivateKey((String)"-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testinstallPrivateKeyNPE() {
        AWSEC2TemplateOptions.Builder.installPrivateKey(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testauthorizePublicKeyBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.authorizePublicKey("whompy");
    }

    @Test
    public void testauthorizePublicKey() throws IOException {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.authorizePublicKey("ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test
    public void testNullauthorizePublicKey() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((String)options.getPublicKey(), null);
    }

    @Test
    public void testauthorizePublicKeyStatic() throws IOException {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.authorizePublicKey((String)"ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testauthorizePublicKeyNPE() {
        AWSEC2TemplateOptions.Builder.authorizePublicKey(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testblockOnPortBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.blockOnPort(-1, -1);
    }

    @Test
    public void testblockOnPort() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.blockOnPort(22, 30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test
    public void testNullblockOnPort() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((int)options.getPort(), (int)-1);
        Assert.assertEquals((int)options.getSeconds(), (int)-1);
    }

    @Test
    public void testblockOnPortStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.blockOnPort((int)22, (int)30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinboundPortsBadFormat() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.inboundPorts(new int[]{-1, -1});
    }

    @Test
    public void testinboundPorts() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.inboundPorts(new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }

    @Test
    public void testDefaultOpen22() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
    }

    @Test
    public void testinboundPortsStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.inboundPorts((int[])new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }

    @Test
    public void testIAMInstanceProfileArn() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.iamInstanceProfileArn("arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver");
        Assert.assertEquals((String)options.getIAMInstanceProfileArn(), (String)"arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver");
    }

    @Test
    public void testNullIAMInstanceProfileArn() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((String)options.getIAMInstanceProfileArn(), null);
    }

    @Test
    public void testIAMInstanceProfileArnStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.iamInstanceProfileArn((String)"arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver");
        Assert.assertEquals((String)options.getIAMInstanceProfileArn(), (String)"arn:aws:iam::123456789012:instance-profile/application_abc/component_xyz/Webserver");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIAMInstanceProfileArnNPE() {
        AWSEC2TemplateOptions.Builder.iamInstanceProfileArn(null);
    }

    @Test
    public void testIAMInstanceProfileName() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        options.iamInstanceProfileName("Webserver");
        Assert.assertEquals((String)options.getIAMInstanceProfileName(), (String)"Webserver");
    }

    @Test
    public void testNullIAMInstanceProfileName() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        Assert.assertEquals((String)options.getIAMInstanceProfileName(), null);
    }

    @Test
    public void testIAMInstanceProfileNameStatic() {
        AWSEC2TemplateOptions options = AWSEC2TemplateOptions.Builder.iamInstanceProfileName((String)"Webserver");
        Assert.assertEquals((String)options.getIAMInstanceProfileName(), (String)"Webserver");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIAMInstanceProfileNameNPE() {
        AWSEC2TemplateOptions.Builder.iamInstanceProfileName(null);
    }
}

