/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.functions;

import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SpotInstanceRequestToAWSRunningInstanceTest")
public class SpotInstanceRequestToAWSRunningInstanceTest {
    public void testConvert() {
        SpotInstanceRequest input = SpotInstanceRequest.builder().region("us-east-1").id("sir-228e6406").spotPrice(0.001f).type(SpotInstanceRequest.Type.ONE_TIME).state(SpotInstanceRequest.State.OPEN).rawState("open").launchSpecification(LaunchSpecification.builder().imageId("ami-595a0a1c").securityGroupName("default").instanceType("m1.large").mapNewVolumeToDevice("/dev/sda1", 1, true).mapEBSSnapshotToDevice("/dev/sda2", "snap-1ea27576", Integer.valueOf(1), true).mapEphemeralDeviceToDevice("/dev/sda3", "vre1").monitoringEnabled(Boolean.valueOf(false)).build()).createTime(new SimpleDateFormatDateService().iso8601DateParse("2011-03-08T03:30:36.000Z")).productDescription("Linux/UNIX").tag("foo", "bar").tag("empty", "").build();
        Assert.assertEquals((String)new SpotInstanceRequestToAWSRunningInstance().apply(input).toString(), (String)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)AWSRunningInstance.builder().region("us-east-1")).instanceId("sir-228e6406")).spotInstanceRequestId("sir-228e6406").instanceState(InstanceState.PENDING)).rawState("open")).imageId("ami-595a0a1c")).groupName("default")).instanceType("m1.large")).tag("foo", "bar")).tag("empty", "")).hypervisor(Hypervisor.XEN).monitoringState(MonitoringState.DISABLED).build().toString());
    }

    public void testConvertWhenNotOpenReturnsNull() {
        Assert.assertEquals((Object)new SpotInstanceRequestToAWSRunningInstance().apply(SpotInstanceRequest.builder().region("us-east-1").id("sir-228e6406").type(SpotInstanceRequest.Type.ONE_TIME).state(SpotInstanceRequest.State.ACTIVE).rawState("active").build()), null);
        Assert.assertEquals((Object)new SpotInstanceRequestToAWSRunningInstance().apply(SpotInstanceRequest.builder().region("us-east-1").id("sir-228e6406").type(SpotInstanceRequest.Type.ONE_TIME).rawState("one-time").state(SpotInstanceRequest.State.CANCELLED).build()), null);
        Assert.assertEquals((Object)new SpotInstanceRequestToAWSRunningInstance().apply(SpotInstanceRequest.builder().region("us-east-1").id("sir-228e6406").type(SpotInstanceRequest.Type.ONE_TIME).rawState("one-time").state(SpotInstanceRequest.State.UNRECOGNIZED).build()), null);
    }
}

