/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import java.util.Map;
import org.jclouds.aws.ec2.AWSEC2ApiMetadata;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.services.MonitoringClient;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class MonitoringClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private MonitoringClient client;
    private static final String DEFAULT_INSTANCE = "i-TODO";

    public MonitoringClientLiveTest() {
        this.provider = "aws-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = ((AWSEC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN)).getApi()).getMonitoringServices();
    }

    @Test(enabled=false)
    public void testMonitorInstances() {
        Map monitoringState = this.client.monitorInstancesInRegion(null, DEFAULT_INSTANCE, new String[0]);
        Assert.assertEquals(monitoringState.get(DEFAULT_INSTANCE), (Object)MonitoringState.PENDING);
    }

    @Test(enabled=false)
    public void testUnmonitorInstances() {
        Map monitoringState = this.client.unmonitorInstancesInRegion(null, DEFAULT_INSTANCE, new String[0]);
        Assert.assertEquals(monitoringState.get(DEFAULT_INSTANCE), (Object)MonitoringState.PENDING);
    }
}

