/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.aws.domain.Region;
import org.jclouds.aws.ec2.AWSEC2ApiMetadata;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.domain.Spot;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.options.DescribeSpotPriceHistoryOptions;
import org.jclouds.aws.ec2.options.RequestSpotInstancesOptions;
import org.jclouds.aws.ec2.predicates.SpotInstanceRequestActive;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.rest.RestContext;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class SpotInstanceClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private static final int SPOT_DELAY_SECONDS = 600;
    private AWSEC2Client client;
    private Predicate<SpotInstanceRequest> activeTester;
    private Set<SpotInstanceRequest> requests;
    private AWSRunningInstance instance;
    private long start;
    public static final String PREFIX = System.getProperty("user.name") + "ec2";

    public SpotInstanceClientLiveTest() {
        this.provider = "aws-ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.client = (AWSEC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(AWSEC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.activeTester = Predicates2.retry((Predicate)new SpotInstanceRequestActive(this.client), (long)600L, (long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    void testDescribeSpotRequestsInRegion() {
        for (String region : Region.DEFAULT_REGIONS) {
            ImmutableSortedSet allResults = ImmutableSortedSet.copyOf((Collection)this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            SpotInstanceRequest request = (SpotInstanceRequest)allResults.last();
            ImmutableSortedSet result = ImmutableSortedSet.copyOf((Collection)this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(region, new String[]{request.getId()}));
            Assert.assertNotNull((Object)result);
            SpotInstanceRequest compare = (SpotInstanceRequest)result.last();
            Assert.assertEquals((Object)compare, (Object)request);
        }
    }

    @Test
    void testDescribeSpotPriceHistoryInRegion() {
        for (String region : Region.DEFAULT_REGIONS) {
            Set spots = this.client.getSpotInstanceServices().describeSpotPriceHistoryInRegion(region, new DescribeSpotPriceHistoryOptions[]{DescribeSpotPriceHistoryOptions.Builder.from((Date)new Date())});
            Assert.assertNotNull((Object)spots);
            assert (spots.size() > 0);
            for (Spot spot : spots) {
                assert (spot.getSpotPrice() > 0.0f) : spots;
                Assert.assertEquals((String)spot.getRegion(), (String)region);
                assert (Predicates.in((Collection)ImmutableSet.of((Object)"Linux/UNIX", (Object)"Linux/UNIX (Amazon VPC)", (Object)"SUSE Linux", (Object)"SUSE Linux (Amazon VPC)", (Object)"Windows", (Object)"Windows (Amazon VPC)", (Object[])new String[0])).apply((Object)spot.getProductDescription())) : spot;
                assert (Predicates.in((Collection)ImmutableSet.of((Object)"c1.medium", (Object)"c1.xlarge", (Object)"cc1.4xlarge", (Object)"cg1.4xlarge", (Object)"cc2.8xlarge", (Object)"m1.large", (Object[])new String[]{"m1.small", "m1.medium", "m1.xlarge", "m2.2xlarge", "m2.4xlarge", "m2.xlarge", "m3.xlarge", "m3.2xlarge", "t1.micro"})).apply((Object)spot.getInstanceType())) : spot;
            }
        }
    }

    @Test(enabled=true)
    void testCreateSpotInstance() {
        String launchGroup = PREFIX + "1";
        for (String region : Region.DEFAULT_REGIONS) {
            for (SpotInstanceRequest request : this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(region, new String[0])) {
                if (!launchGroup.equals(request.getLaunchGroup())) continue;
                this.client.getSpotInstanceServices().cancelSpotInstanceRequestsInRegion(region, new String[]{request.getId()});
            }
        }
        this.start = System.currentTimeMillis();
        this.requests = this.client.getSpotInstanceServices().requestSpotInstancesInRegion("sa-east-1", 0.09f, 1, LaunchSpecification.builder().imageId("ami-3e3be423").instanceType("m1.small").build(), new RequestSpotInstancesOptions[]{RequestSpotInstancesOptions.Builder.launchGroup((String)launchGroup).availabilityZoneGroup(launchGroup).validFrom(new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L))).validUntil(new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(600L)))});
        Assert.assertNotNull(this.requests);
        for (SpotInstanceRequest request : this.requests) {
            this.verifySpotInstance(request);
        }
    }

    private void verifySpotInstance(SpotInstanceRequest request) {
        SpotInstanceRequest spot = this.refresh(request);
        Assert.assertNotNull((Object)spot);
        Assert.assertEquals((Object)spot, (Object)request);
        assert (this.activeTester.apply((Object)request)) : this.refresh(request);
        System.out.println(System.currentTimeMillis() - this.start);
        spot = this.refresh(request);
        assert (spot.getInstanceId() != null) : spot;
        this.instance = (AWSRunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)this.client.getInstanceServices().describeInstancesInRegion(spot.getRegion(), new String[]{spot.getInstanceId()}))));
        Assert.assertEquals((String)this.instance.getSpotInstanceRequestId(), (String)spot.getId());
    }

    public SpotInstanceRequest refresh(SpotInstanceRequest request) {
        return (SpotInstanceRequest)Iterables.getOnlyElement((Iterable)this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(request.getRegion(), new String[]{request.getId()}));
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        if (this.requests != null) {
            for (SpotInstanceRequest request : this.requests) {
                this.client.getSpotInstanceServices().cancelSpotInstanceRequestsInRegion(request.getRegion(), new String[]{request.getId()});
            }
        }
        if (this.instance != null) {
            this.client.getInstanceServices().terminateInstancesInRegion(this.instance.getRegion(), new String[]{this.instance.getId()});
        }
        super.tearDownContext();
    }
}

