/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.xml.AWSRunInstancesResponseHandler;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.location.Region;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RunInstancesResponseHandlerTest")
public class AWSRunInstancesResponseHandlerTest
extends BaseEC2HandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(Region.class).toInstance((Object)Suppliers.ofInstance((Object)"us-east-1"));
                this.bind(RunningInstance.Builder.class).to(AWSRunningInstance.Builder.class);
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/run_instances.xml");
        Reservation expected = Reservation.builder().region(this.defaultRegion).instance((RunningInstance)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)AWSRunningInstance.builder().region(this.defaultRegion)).groupName("default")).amiLaunchIndex("0")).imageId("ami-60a54009")).instanceId("i-2ba64342")).instanceState(InstanceState.PENDING)).rawState("pending")).instanceType("m1.small")).keyName("example-key-name")).launchTime(this.dateService.iso8601DateParse("2007-08-07T11:51:50.000Z"))).hypervisor(Hypervisor.XEN).monitoringState(MonitoringState.ENABLED).availabilityZone("us-east-1b")).build()).instance((RunningInstance)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)AWSRunningInstance.builder().region(this.defaultRegion)).groupName("default")).amiLaunchIndex("1")).imageId("ami-60a54009")).instanceId("i-2bc64242")).instanceState(InstanceState.PENDING)).rawState("pending")).instanceType("m1.small")).keyName("example-key-name")).launchTime(this.dateService.iso8601DateParse("2007-08-07T11:51:50.000Z"))).hypervisor(Hypervisor.XEN).monitoringState(MonitoringState.ENABLED).availabilityZone("us-east-1b")).build()).instance((RunningInstance)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)((AWSRunningInstance.Builder)AWSRunningInstance.builder().region(this.defaultRegion)).groupName("default")).amiLaunchIndex("2")).imageId("ami-60a54009")).instanceId("i-2be64332")).instanceState(InstanceState.PENDING)).rawState("pending")).instanceType("m1.small")).keyName("example-key-name")).launchTime(this.dateService.iso8601DateParse("2007-08-07T11:51:50.000Z"))).hypervisor(Hypervisor.XEN).monitoringState(MonitoringState.ENABLED).availabilityZone("us-east-1b")).build()).ownerId("AIDADH4IGTRXXKCD").reservationId("r-47a5402e").build();
        AWSRunInstancesResponseHandler handler = (AWSRunInstancesResponseHandler)this.injector.getInstance(AWSRunInstancesResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Reservation result = (Reservation)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public void testApplyInputStreamDoesntNPE() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/run_instances_1.xml");
        AWSRunInstancesResponseHandler handler = (AWSRunInstancesResponseHandler)this.injector.getInstance(AWSRunInstancesResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

