/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.Set;
import org.jclouds.aws.ec2.domain.Spot;
import org.jclouds.aws.ec2.xml.DescribeSpotPriceHistoryResponseHandler;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeSpotPriceHistoryResponseHandlerTest")
public class DescribeSpotPriceHistoryResponseHandlerTest
extends BaseHandlerTest {
    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_spot_price_history.xml");
        ImmutableSet expected = ImmutableSet.of((Object)Spot.builder().region("us-west-1").instanceType("t1.micro").productDescription("SUSE Linux").spotPrice(0.013f).timestamp(new SimpleDateFormatDateService().iso8601DateParse("2011-03-07T12:17:19.000Z")).availabilityZone("us-west-1a").build(), (Object)Spot.builder().region("us-west-1").instanceType("m1.large").productDescription("Linux/UNIX").spotPrice(0.119f).timestamp(new SimpleDateFormatDateService().iso8601DateParse("2011-03-07T16:29:16.000Z")).availabilityZone("us-west-1b").build(), (Object)Spot.builder().region("us-west-1").instanceType("t1.micro").productDescription("Windows").spotPrice(0.013f).timestamp(new SimpleDateFormatDateService().iso8601DateParse("2011-03-07T17:56:54.000Z")).availabilityZone("us-west-1c").build());
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)this.injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(Region.class).toInstance((Object)Suppliers.ofInstance((Object)"us-west-1"));
            }
        }}).getInstance(DescribeSpotPriceHistoryResponseHandler.class)).parse(is);
        Assert.assertEquals((Set)result, (Set)expected);
    }
}

