/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.aws.domain.Region;
import org.jclouds.aws.ec2.AWSEC2ApiMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

public class AWSEC2ProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AWSEC2ProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this);
    }

    public AWSEC2ProviderMetadata() {
        super((BaseProviderMetadata.Builder)AWSEC2ProviderMetadata.builder());
    }

    public AWSEC2ProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.compute.timeout.node-suspended", "120000");
        properties.putAll((Map<?, ?>)Region.regionProperties());
        properties.setProperty("jclouds.ec2.ami-query", "owner-id=137112412989,801119661308,063491364108,099720109477,411009282317;state=available;image-type=machine");
        properties.setProperty("jclouds.ec2.cc-regions", "us-east-1,us-west-2,eu-west-1");
        properties.setProperty("jclouds.ec2.cc-ami-query", "virtualization-type=hvm;architecture=x86_64;owner-id=137112412989,099720109477;hypervisor=xen;state=available;image-type=machine;root-device-type=ebs");
        properties.setProperty("jclouds.template", "osFamily=AMZN_LINUX,os64Bit=true");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("aws-ec2").name("Amazon Elastic Compute Cloud (EC2)").apiMetadata((ApiMetadata)new AWSEC2ApiMetadata()).endpoint("https://ec2.us-east-1.amazonaws.com").homepage(URI.create("http://aws.amazon.com/ec2")).console(URI.create("https://console.aws.amazon.com/ec2/home")).defaultProperties(AWSEC2ProviderMetadata.defaultProperties()).linkedServices(new String[]{"aws-ec2", "aws-elb", "aws-cloudwatch", "aws-s3", "aws-simpledb"}).iso3166Codes(new String[]{"US-VA", "US-CA", "US-OR", "BR-SP", "IE", "SG", "AU-NSW", "JP-13"});
        }

        public AWSEC2ProviderMetadata build() {
            return new AWSEC2ProviderMetadata(this);
        }

        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

