/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.javax.annotation.Nullable;

public class CreateDriveRequest
extends Drive {
    private final Set<String> avoid;
    @Nullable
    private final String encryptionCipher;

    public CreateDriveRequest(String name, long size, @Nullable ClaimType claimType, Iterable<String> tags, Iterable<String> readers, Iterable<String> use, @Nullable String encryptionCipher, Iterable<String> avoid) {
        super(null, name, size, claimType, tags, readers, use);
        this.encryptionCipher = encryptionCipher;
        this.avoid = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(avoid, (Object)"avoid")));
    }

    public Set<String> getAvoid() {
        return this.avoid;
    }

    @Nullable
    public String getEncryptionCipher() {
        return this.encryptionCipher;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.avoid == null ? 0 : this.avoid.hashCode());
        result = 31 * result + (this.encryptionCipher == null ? 0 : this.encryptionCipher.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateDriveRequest other = (CreateDriveRequest)obj;
        if (this.avoid == null ? other.avoid != null : !this.avoid.equals(other.avoid)) {
            return false;
        }
        return !(this.encryptionCipher == null ? other.encryptionCipher != null : !this.encryptionCipher.equals(other.encryptionCipher));
    }

    @Override
    public String toString() {
        return "[name=" + this.name + ", size=" + this.size + ", claimType=" + (Object)((Object)this.claimType) + ", tags=" + this.tags + ", readers=" + this.readers + ", use=" + this.use + ", avoid=" + this.avoid + ", encryptionCipher=" + this.encryptionCipher + "]";
    }

    public static class Builder
    extends Drive.Builder {
        private Set<String> avoid = ImmutableSet.of();
        @Nullable
        private String encryptionCipher;

        public Builder avoid(Iterable<String> avoid) {
            this.avoid = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(avoid, (Object)"avoid")));
            return this;
        }

        @Override
        public Builder claimType(ClaimType claimType) {
            return (Builder)Builder.class.cast(super.claimType(claimType));
        }

        public Builder encryptionCipher(String encryptionCipher) {
            this.encryptionCipher = encryptionCipher;
            return this;
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder tags(Iterable<String> tags) {
            return (Builder)Builder.class.cast(super.tags(tags));
        }

        @Override
        public Builder readers(Iterable<String> readers) {
            return (Builder)Builder.class.cast(super.readers(readers));
        }

        @Override
        public Builder size(long size) {
            return (Builder)Builder.class.cast(super.size(size));
        }

        @Override
        public Builder use(Iterable<String> use) {
            return (Builder)Builder.class.cast(super.use((Iterable)use));
        }

        @Override
        public CreateDriveRequest build() {
            return new CreateDriveRequest(this.name, this.size, this.claimType, this.tags, this.readers, this.use, this.encryptionCipher, this.avoid);
        }
    }
}

