/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.Item;
import org.jclouds.javax.annotation.Nullable;

public class Drive
extends Item {
    protected final long size;
    protected final ClaimType claimType;
    protected final Set<String> tags;
    protected final Set<String> readers;

    public Drive(@Nullable String uuid, String name, long size, @Nullable ClaimType claimType, Iterable<String> tags, Iterable<String> readers, Iterable<String> use) {
        super(uuid, name, use);
        this.size = size;
        this.claimType = (ClaimType)((Object)Preconditions.checkNotNull((Object)((Object)claimType), (Object)"set claimType to exclusive, not null"));
        this.tags = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(tags, (Object)"tags")));
        this.readers = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(readers, (Object)"readers")));
    }

    @Nullable
    public ClaimType getClaimType() {
        return this.claimType;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.claimType == null ? 0 : this.claimType.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.readers == null ? 0 : this.readers.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.use == null ? 0 : this.use.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Drive other = (Drive)obj;
        if (this.claimType != other.claimType) {
            return false;
        }
        if (!Objects.equal(this.tags, other.tags)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)other.name)) {
            return false;
        }
        if (!Objects.equal(this.readers, other.readers)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return !(this.use == null ? other.use != null : !this.use.equals(other.use));
    }

    @Override
    public String toString() {
        return "[uuid=" + this.uuid + ", name=" + this.name + ", use=" + this.use + ", size=" + this.size + ", claimType=" + (Object)((Object)this.claimType) + ", tags=" + this.tags + ", readers=" + this.readers + "]";
    }

    public static class Builder
    extends Item.Builder {
        protected long size;
        protected ClaimType claimType = ClaimType.EXCLUSIVE;
        protected Set<String> tags = ImmutableSet.of();
        protected Set<String> readers = ImmutableSet.of();

        public Builder claimType(ClaimType claimType) {
            this.claimType = claimType;
            return this;
        }

        public Builder tags(Iterable<String> tags) {
            this.tags = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public Builder readers(Iterable<String> readers) {
            this.readers = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(readers, (Object)"readers")));
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        @Override
        public Builder uuid(String uuid) {
            return (Builder)Builder.class.cast(super.uuid(uuid));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder use(Iterable<String> use) {
            return (Builder)Builder.class.cast(super.use(use));
        }

        @Override
        public Drive build() {
            return new Drive(this.uuid, this.name, this.size, this.claimType, this.tags, this.readers, this.use);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.claimType == null ? 0 : this.claimType.hashCode());
            result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
            result = 31 * result + (this.readers == null ? 0 : this.readers.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.claimType != other.claimType) {
                return false;
            }
            if (!Objects.equal(this.tags, other.tags)) {
                return false;
            }
            if (!Objects.equal(this.readers, other.readers)) {
                return false;
            }
            return this.size == other.size;
        }
    }
}

