/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudsigma.domain.Model;
import org.jclouds.javax.annotation.Nullable;

public class NIC {
    private final String dhcp;
    private final Model model;
    private final String vlan;
    private final String mac;
    private final Set<String> block;

    public NIC(@Nullable String dhcp, Model model, @Nullable String vlan, @Nullable String mac, Iterable<String> block) {
        this.dhcp = dhcp;
        this.model = (Model)((Object)Preconditions.checkNotNull((Object)((Object)model), (Object)"model"));
        this.vlan = vlan;
        this.mac = mac;
        this.block = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(block, (Object)"block")));
    }

    public String getDhcp() {
        return this.dhcp;
    }

    public Model getModel() {
        return this.model;
    }

    public String getVlan() {
        return this.vlan;
    }

    public String getMac() {
        return this.mac;
    }

    public Set<String> getBlock() {
        return this.block;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        result = 31 * result + (this.dhcp == null ? 0 : this.dhcp.hashCode());
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.vlan == null ? 0 : this.vlan.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NIC other = (NIC)obj;
        if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
            return false;
        }
        if (this.dhcp == null ? other.dhcp != null : !this.dhcp.equals(other.dhcp)) {
            return false;
        }
        if (this.mac == null ? other.mac != null : !this.mac.equals(other.mac)) {
            return false;
        }
        if (this.model != other.model) {
            return false;
        }
        return !(this.vlan == null ? other.vlan != null : !this.vlan.equals(other.vlan));
    }

    public String toString() {
        return "[dhcp=" + this.dhcp + ", model=" + (Object)((Object)this.model) + ", vlan=" + this.vlan + ", mac=" + this.mac + ", block=" + this.block + "]";
    }

    public static class Builder {
        private String dhcp;
        private Model model;
        private String vlan;
        private String mac;
        private Set<String> block = ImmutableSet.of();

        public Builder dhcp(String dhcp) {
            this.dhcp = dhcp;
            return this;
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder vlan(String vlan) {
            this.vlan = vlan;
            return this;
        }

        public Builder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public Builder block(Iterable<String> block) {
            this.block = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(block, (Object)"block")));
            return this;
        }

        public NIC build() {
            return new NIC(this.dhcp, this.model, this.vlan, this.mac, this.block);
        }
    }
}

