/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.cloudsigma.domain.DriveMetrics;

public class ServerMetrics {
    protected final long txPackets;
    protected final long tx;
    protected final long rxPackets;
    protected final long rx;
    protected final Map<String, DriveMetrics> driveMetrics;

    public ServerMetrics(long tx, long txPackets, long rx, long rxPackets, Map<String, DriveMetrics> driveMetrics) {
        this.txPackets = txPackets;
        this.tx = tx;
        this.rxPackets = rxPackets;
        this.rx = rx;
        this.driveMetrics = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(driveMetrics, (Object)"driveMetrics")));
    }

    public long getTxPackets() {
        return this.txPackets;
    }

    public long getTx() {
        return this.tx;
    }

    public long getRxPackets() {
        return this.rxPackets;
    }

    public long getRx() {
        return this.rx;
    }

    public Map<String, DriveMetrics> getDriveMetrics() {
        return this.driveMetrics;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.driveMetrics == null ? 0 : this.driveMetrics.hashCode());
        result = 31 * result + (int)(this.rx ^ this.rx >>> 32);
        result = 31 * result + (int)(this.rxPackets ^ this.rxPackets >>> 32);
        result = 31 * result + (int)(this.tx ^ this.tx >>> 32);
        result = 31 * result + (int)(this.txPackets ^ this.txPackets >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerMetrics other = (ServerMetrics)obj;
        if (this.driveMetrics == null ? other.driveMetrics != null : !this.driveMetrics.equals(other.driveMetrics)) {
            return false;
        }
        if (this.rx != other.rx) {
            return false;
        }
        if (this.rxPackets != other.rxPackets) {
            return false;
        }
        if (this.tx != other.tx) {
            return false;
        }
        return this.txPackets == other.txPackets;
    }

    public String toString() {
        return "[ txPackets=" + this.txPackets + ", tx=" + this.tx + ", rxPackets=" + this.rxPackets + ", rx=" + this.rx + ", driveMetrics=" + this.driveMetrics + "]";
    }

    public static class Builder {
        protected long txPackets;
        protected long tx;
        protected long rxPackets;
        protected long rx;
        protected Map<String, DriveMetrics> driveMetrics = ImmutableMap.of();

        public Builder txPackets(long txPackets) {
            this.txPackets = txPackets;
            return this;
        }

        public Builder tx(long tx) {
            this.tx = tx;
            return this;
        }

        public Builder rxPackets(long rxPackets) {
            this.rxPackets = rxPackets;
            return this;
        }

        public Builder rx(long rx) {
            this.rx = rx;
            return this;
        }

        public Builder driveMetrics(Map<String, ? extends DriveMetrics> driveMetrics) {
            this.driveMetrics = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(driveMetrics, (Object)"driveMetrics")));
            return this;
        }

        public ServerMetrics build() {
            return new ServerMetrics(this.tx, this.txPackets, this.rx, this.rxPackets, this.driveMetrics);
        }
    }
}

